import multiprocessing as mp
from Tasks.TaskManager import TaskManager
import baseOP
import sys
import time
import math
import logging
from logging.handlers import RotatingFileHandler
import os


if __name__=="__main__":
    LOG_FORMAT = "%(asctime)s - %(levelname)s - %(message)s"
    logging.basicConfig(filename='mpi.log', level=logging.INFO, format=LOG_FORMAT)
    #confFile = "conf_monitor.json"
    confFile = "conf.json"
    proj = baseOP.kafkaRec(confFile)
    minRun=293
    seghours=6
    step=3600*25*seghours

    while True:
        
        recList=proj.getRun2Rec(minRun)
        if len(recList)==0:
            pass
        else:
            print("==========================")
            print("need to be reconstructed: ",recList)
            for runno in recList:
                print("start with ",runno)
                be=time.time()
                proj.getPath(runno)
                try:
                    t1,t2=proj.getPulseInfoFromFile(runno)
                except:
                    continue
                bins=math.ceil((t2-t1)*1.0/step)
                binList=[]
                for i in range(bins):
                    binList.append(i)
                    startT=t1+step*i
                    if startT+step<t2:
                        endT=startT+step
                    else:
                        endT=t2
                    proj.getTask("offline",startT,endT,i)
                    tasks=proj.myDict
                    #print(tasks)
                    if len(tasks) == 0:
                        sys.exit(0)
                    man = TaskManager(tasks)
                    while True:
                        print("num of processes ",len(man.processes))
                        if len(man.processes)==0:
                            man.stopProc()
                            break
                        time.sleep(30)
                #fill modules evt into hist
                tasks={}
                tasks=proj.getTask2(binList)
                if len(tasks) == 0:
                    sys.exit(0)
                man = TaskManager(tasks)
                while True:
                    print("num of processes ",len(man.processes))
                    if len(man.processes)==0:
                        man.stopProc()
                        break
                    time.sleep(60)

                #merge all hist nxs
                proj.mergeNxs(runno,t1,t2)
                proj.sendData(runno)
                print("finish ",runno, str((time.time()-be)/60.0)," minutes")
        time.sleep(10)
