
import multiprocessing as mp
from time import sleep
from Tasks.TaskManager import TaskManager
import json
import baseOP
import sys

if __name__=="__main__":
    confFile = "conf.json"
    with open(confFile,"r") as json_file:
        conf=json.load(json_file)

    xmlPath="/home/da/iMACS/writeIDF/idf"
    dataPath="/home/da/"+sys.argv[1]
    baseOP.createDir(dataPath)

    tasks={}
    for _item in conf['modules']['detector_modules']:
        if _item.get('enabled') is not None:
            if _item['enabled'] == False:
                print(f'{_item["topic"]} is not enabled, skip.')
                continue
        _taskName = baseOP.getModuleName(_item)
        tasks[_taskName]=[baseOP.onlineDetector,(_item,1,_taskName,dataPath,xmlPath)]
    if len(tasks) == 0:
        sys.exit(0)

    mp.set_start_method('fork')
    print('Starting task manager')
    man = TaskManager(tasks)
    print("main thread sleeping")
    sleep(100000000)
    man.stopProc()
    print ('Main exit')
