from IO.RedisHelper import RedisHelper
import multiprocessing as mp
from time import sleep
from Tasks.TaskManager import TaskManager
import json
import baseOP
import sys
import numpy as np
import time

def getRedisHelper(redis_conf):
    _mode = redis_conf['mode'].lower()
    _password = redis_conf['password']
    _servers = []
    for _item in redis_conf['servers']:
        _servers.append((_item['host'], _item['port']))

    if _mode == 'standalone':
        return RedisHelper(_servers[0], _password, 10)
    elif _mode == 'sentinel':
        return RedisHelper(_servers, _password, 10, master_name=redis_conf['master_name'])
    else:
        raise Exception(f'Redis mode not supported: {_mode}')


if __name__=="__main__":
    confFile = "conf.json"
    with open(confFile,"r") as json_file:
        conf=json.load(json_file)

    rds=getRedisHelper(conf["redis"]) 
    path="/mpi/expRecInfo"
    xmlPath="/home/da/iMACS/writeIDF/idf"

    tc=baseOP.timeConvert()
    judgeT0=0 
    while True:
        expInfo = rds.read(path)
        if expInfo is None:
            print("This is None!")
            time.sleep(10)
        else:
            print(expInfo)
            startT0=int(expInfo["startPulseId"])
            if startT0-judgeT0>5:
                judgeT0=startT0
                endT0=int(expInfo["endPulseId"])
                runNo=expInfo["runNo"]
                startLocal=tc.pulseId2Local(startT0)
                startStamp=tc.local_to_utc_stamp(startLocal)
                endLocal=tc.pulseId2Local(endT0)
                endStamp=tc.local_to_utc_stamp(endLocal)
                now_tmp=time.time()
                hoursBefore=int((now_tmp-startStamp)/3600)
                print(hoursBefore)

                tofbins=2500
                chunksize=10000
                dataPath="/home/da/test/"+runNo
                baseOP.createDir(dataPath)

                time_of_flight=baseOP.getTimeOfFlight(tofbins)
                tasks={}
                moduleList=[]
                monitorList=[]
                for _item in conf['modules']['detector_modules']:
                    if _item.get('enabled') is not None:
                        if _item['enabled'] == False:
                            print(f'{_item["topic"]} is not enabled, skip.')
                            continue
                    _taskName = baseOP.getModuleName(_item)
                    length=int(_item["module_length"])
                    pixel_id = baseOP.getPixelId(_taskName,length)
                    tasks[_taskName]=[baseOP.onlineDetector,(_item,hoursBefore,_taskName,dataPath,pixel_id,time_of_flight,chunksize,startT0,endT0)]
                    moduleList.append(_taskName)
                #add monitor
                for _item in conf['modules']['monitor_modules']:
                    if _item.get('enabled') is not None:
                        if _item['enabled'] == False:
                            print(f'{_item["topic"]} is not enabled, skip.')
                            continue
                    if _item["data_type"] == "event":
                        _taskName = baseOP.getMonitorName(_item)
                        pixel_id = baseOP.getMonitorPixelId(_taskName)
                        tasks[_taskName]=[baseOP.onlineDetector,(_item,hoursBefore,_taskName,dataPath,pixel_id,time_of_flight,chunksize,startT0,endT0)]
                        monitorList.append(_taskName)
                    #break
                print(tasks)


                #break
                #print(tasks)
                if len(tasks) == 0:
                    sys.exit(0)

                mp.set_start_method('fork')
                print('Starting task manager')
                man = TaskManager(tasks)
                print("main thread sleeping")
                sleep(100000000)
                man.stopProc()
                print ('Main exit')

                #start merge detector.nxs
                savePath="/home/da"+runNo
                baseOP.createDir(savePath)
                #write public information
                pubDict={"start_time_utc":[bytes(startLocal,encoding="utf8")],
                         "end_time_utc":[bytes(endLocal,encoding="utf8")],
                         "start_time_tai":[bytes(startStamp,encoding="utf8")],
                         "end_time_tai":[bytes(endStamp,encoding="utf8")],
                         "beamline":[b"BL15"],
                         "run_no":[bytes(runNo,encoding="utf8")]}
                
                run = baseComp.nxsWrite()
                run.mergeModules(dataPath,pubDict,moduleInfo,monitorList)
                _cmd="cp "+dataPath+"/detector.nxs "+savePath
                subprocess.check_call(_cmd, shell=True)
                transPath1="da@10.1.37.246:/data/mpi/BL16-commissioning/"
                transPath2="root@10.1.231.231:/userData/BL16/BL16-commissioning/"

                _cmd="scp -r "+savePath+" "+transPath1
                subprocess.check_call(_cmd, shell=True)
                _cmd = 'scp complete  '+transPath1+runNo
                subprocess.check_call(_cmd, shell=True)
                _cmd="scp -r "+savePath+" "+transPath2
                subprocess.check_call(_cmd, shell=True)
                _cmd = 'scp complete  '+transPath2+runNo
                subprocess.check_call(_cmd, shell=True)

                _cmd = 'rm -rf '+savePath
                subprocess.check_call(_cmd, shell=True)

            else:
                time.sleep(10)

