import baseComp
import baseOP
import json
import sys
import subprocess

if __name__=="__main__":
    confFile = "conf.json"
    with open(confFile,"r") as json_file:
        conf=json.load(json_file)

    xmlPath="/home/da/iMACS/writeIDF/idf"
    moduleFile=sys.argv[1]
    dataPath="/home/da/"+moduleFile
    runNo=sys.argv[2]
    savePath="/home/da/"+runNo
    baseOP.createDir(savePath)
    moduleInfo=[]
    for _item in conf['modules']['detector_modules']:
        if _item.get('enabled') is not None:
            if _item['enabled'] == False:
                print(f'{_item["topic"]} is not enabled, skip.')
                continue
        moduleInfo.append(baseOP.getModuleName(_item))
 
    start_time_utc="2021-01-01 00:00:00"
    pubDict={"start_time_utc":[bytes(start_time_utc,encoding="utf8")],
            "end_time_utc":[b"2021-01-02 00:00:00"],
            "start_time_tai":[b"123456789"],
            "end_time_tai":[b"123456789"],
            "beamline":[b"BL15"],
            "run_no":[bytes(runNo,encoding="utf8")]}
    

    monitorList=['monitor01']
    run = baseComp.nxsWrite()
    run.mergeModules(dataPath,pubDict,moduleInfo,monitorList)
    _cmd="cp "+dataPath+"/detector.nxs "+savePath
    subprocess.check_call(_cmd, shell=True)
    transPath1="da@10.1.37.246:/data/mpi/BL16-commissioning/"
    transPath2="root@10.1.231.231:/userData/BL16/BL16-commissioning/"

    _cmd="scp -r "+savePath+" "+transPath1
    subprocess.check_call(_cmd, shell=True)
    _cmd = 'scp complete  '+transPath1+runNo
    subprocess.check_call(_cmd, shell=True)
    _cmd="scp -r "+savePath+" "+transPath2
    subprocess.check_call(_cmd, shell=True)
    _cmd = 'scp complete  '+transPath2+runNo
    subprocess.check_call(_cmd, shell=True)

    _cmd = 'rm -rf '+savePath
    subprocess.check_call(_cmd, shell=True)
