import os
import sys
#import redis
#from redis.sentinel import Sentinel
import time
import json
import struct
import epics
from epics import ca, caget, caput, cainfo, camonitor
from epics import pv
import signal
from time import sleep

__STOP__ = False

def sigint_handler(signum, frame):
    global __STOP__
    __STOP__ = True
    print('\n*** Stop signal recieved, will stop soon. ***\n')

def bytes2numpy(encoded):
    dim= struct.unpack('Q',encoded[:8])[0]
    shapeEndPos = 8 + dim*8
    shape = struct.unpack('Q'*dim, encoded[8:shapeEndPos])
    dtypelen = struct.unpack('Q',encoded[shapeEndPos:(shapeEndPos+8)])[0]
    #dtypestr = ''.join([chr(i) for i in encoded[(shapeEndPos+8):(shapeEndPos+8+dtypelen)]])
    dtypestr = 'float64'

    return np.frombuffer(encoded[(shapeEndPos+8+dtypelen):], dtype=dtypestr).reshape(shape)

def on_value_change(pvname, value=None, char_value=None, state=None, timestamp=None, **kw):
    print(kw)
    if state != 0:
        print('PV not ok.')
    print(f'{pvname}: {value}, {time.ctime(timestamp)}')

def on_connect_change(pvname, conn=None, **kw):
    print(f'PV: {pvname}, connected: {conn}')

# signal.signal(signal.SIGINT, sigint_handler)

#ca.initialize_libca()
#epics.ca.PREEMPTIVE_CALLBACK = True

#os.environ['EPICS_CA_AUTO_ADDR_LIST'] = 'NO'
#os.environ['EPICS_CA_MAX_ARRAY_BYTES'] = '20100300'
#os.environ['EPICS_CA_ADDR_LIST']='10.1.37.218:5064'
#os.environ['EPICS_CA_ADDR_LIST']='10.1.37.218:6000'  # Sample Environment
#os.environ['EPICS_CA_ADDR_LIST']='10.1.37.218:42278'  # Run State
#os.environ['EPICS_CA_ADDR_LIST']='10.1.37.218:6001'  # Choper
#epics.ca.find_libca()
#epics.cainfo('egcsHost:ai1', print_out=True)
#pv_ready = 'EXP_IB1_MPI:NO:T1:StaInSync:bi'
#pv_ready = 'EXP_IB1_MPI:NO:T1:StaMotDone:bi'
os.environ['EPICS_CA_ADDR_LIST']='10.1.37.218:6003'  # Sample Environment
pv_ready = 'EXP_IB1_MPI:SE:TEMP:RealtimeVal:ai'
pv_ready = 'EXP_IB1_MPI:SE:TEMP:SEStatus:bi'
pv_ready = 'EXP_IB1_MPI:SE:TEMP:SetSlop:ao'
pv_ready = 'EXP_IB1_MPI:SE:TEMP:SlopFeedback:ai'
pv_ready = 'EXP_IB1_MPI:SE:TEMP:SetAccuracy:ao'
pv_ready = 'EXP_IB1_MPI:SE:TEMP:Set:ao'
pv_ready = 'EXP_IB1_MPI:Set:ao'
pv_ready = 'EXP_IB1_MPI:WR:Global:RunNumber:ai'
pv_ready = 'EXP_IB1_MPI:WR:Global:RunStartID:ai'
pv_ready = 'EXP_IB1_MPI:WR:Global:RunStopID:ai'
pv_ready = 'EXP_IB1_MPI:SAM:CHG1:RUNSt:bi'
pv_ready = 'EXP_IB1_MPI:SAM:CHG1:SamNum:ao'

#pv_ready = 'EXP_IB1_MPI:WR:Global:RunState:bi'
#pv_ready = 'EXP_IB1_MPI:SE:TEMP:Alarm:bo'
#pv_ready = 'EXP_IB1_MPI:SE:TEMP:Name:stringin'
#pv_ready = 'EXP_IB1_MPI:SE:TEMP:Status:bi'
#pv_ready = 'EXP_IB1_MPI:SetMin:ao'
#print(ca.current_context())
#pv_ready = 'EXP_IB1_MPI:NO:T1:SyncAngle:ao'
epics.cainfo(pv_ready, print_out=True)
_tmp = epics.PV(pv_ready, connection_callback=on_connect_change)
_tmp.value=1
print('initial value', _tmp.value)
print(f'type {type(_tmp.value)}')
while True:
    sleep(2)
    val=_tmp.value
    if val==2:
        _tmp.value=1
    else:
        _tmp.value=2
    sleep(0.1)
    print('changing value to', _tmp.value)

#print(dir(_tmp))
#r = epics.caget(f'egcsHost:{_t}{i}', as_string=False, count=None, as_numpy=True, timeout=60, use_monitor=False)
#_r = epics.caput(_pv, _v, wait=True, timeout=60)
sys.exit()

temp_pvs = [
        {
            "name":"EXP_IB1_MPI:RealtimeVal:ai",
            "alias":"rt_val",
            "direction": "input",
            "description": ""
            },
        {
            "name":"EXP_IB1_MPI:Set:ao",
            "alias":"set_val",
            "direction": "output",
            "description": ""
            },
        {
            "name":"EXP_IB1_MPI:SE:TEMP:Status:bi",
            "alias":"status",
            "direction": "input",
            "description": ""
            }
        ]

tempDevice = epics.Device()
for _item in temp_pvs:
    tempDevice.add_pv(_item['name'], attr=_item['alias'])
    if _item['direction'] == 'input':
        tempDevice.add_callback(_item['alias'], on_value_change)
#tempDevice = epics.Device('EXP_IB1_MPI:SE:TEMP:', attrs=('SEStatus:bi', 'Status:bi'))
#tempDevice.put('set_val', 273.15, wait=True, timeout=10.0)
_s = time.time()
current_state = tempDevice.save_state()
#tempDevice.restore_state(current_state)
tempDevice.write_state('epics_state.txt', state=None)
tempDevice.read_state('epics_state.txt', restore=False)
#current_state = tempDevice.rt_val
print(time.time() - _s)
print(current_state)
#for _k in tempDevice._pvs.keys():
#    print(f'{_k}: {tempDevice.get(_k)}')
print('PVcache: ', pv._PVcache_)
sys.exit(0)


redis_hosts = [('10.1.37.231',26379), ('10.1.37.233',26379), ('10.1.37.235',26379)]
sentinel = Sentinel(redis_hosts, socket_timeout=10)
master = 'mpi_redis_master'
p = 'sanlie_123'
w_redis = sentinel.master_for(master, password=p, socket_timeout=10)
r_redis = sentinel.slave_for(master, password=p, socket_timeout=10)
#w.set('/mpi/control/runInfo',json.dumps(None))
path = "/mpi/control/runInfo"
_conf = r_redis.get(path)
if _conf is None or _conf.decode() == 'null':
    print('No data')
print(_conf)

del os.environ['EPICS_CA_ADDR_LIST']
