
import multiprocessing as mp
from time import sleep
from Tasks.TaskManager import TaskManager
import json
import baseOP
import sys
import numpy as np

if __name__=="__main__":
    confFile = "conf.json"
    with open(confFile,"r") as json_file:
        conf=json.load(json_file)

    tofbins=2500
    hoursBefore=1
    chunksize=10000
    xmlPath="/home/da/iMACS/writeIDF/idf"
    dataPath="/home/da/"+sys.argv[1]
    baseOP.createDir(dataPath)
    time_of_flight=baseOP.getTimeOfFlight(tofbins)
    tasks={}
    #add module
    for _item in conf['modules']['detector_modules']:
        if _item.get('enabled') is not None:
            if _item['enabled'] == False:
                print(f'{_item["topic"]} is not enabled, skip.')
                continue
        _taskName = baseOP.getModuleName(_item)
        length=int(_item["module_length"])
        pixel_id = baseOP.getPixelId(_taskName,length)
        tasks[_taskName]=[baseOP.onlineDetector,(_item,hoursBefore,_taskName,dataPath,pixel_id,time_of_flight,chunksize,0,99999999999)]
        #break
    
    #add monitor
    for _item in conf['modules']['monitor_modules']:
        if _item.get('enabled') is not None:
            if _item['enabled'] == False:
                print(f'{_item["topic"]} is not enabled, skip.')
                continue
        if _item["data_type"] == "event":
            _taskName = baseOP.getMonitorName(_item)
            pixel_id = baseOP.getMonitorPixelId(_taskName)
            tasks[_taskName]=[baseOP.onlineDetector,(_item,hoursBefore,_taskName,dataPath,pixel_id,time_of_flight,chunksize,0,99999999999)]
        #break
    print(tasks)
    #sys.exit()
    
    if len(tasks) == 0:
        sys.exit(0)

    mp.set_start_method('fork')
    print('Starting task manager')
    man = TaskManager(tasks)
    print("main thread sleeping")
    sleep(10000000)
    man.stopProc()
    print ('Main exit')
