from IO.RedisHelper import RedisHelper
import json
import baseOP
import sys
import numpy as np
import time
import baseComp
import subprocess
import datetime

def getRedisHelper(redis_conf):
    _mode = redis_conf['mode'].lower()
    _password = redis_conf['password']
    _servers = []
    for _item in redis_conf['servers']:
        _servers.append((_item['host'], _item['port']))

    if _mode == 'standalone':
        return RedisHelper(_servers[0], _password, 10)
    elif _mode == 'sentinel':
        return RedisHelper(_servers, _password, 10, master_name=redis_conf['master_name'])
    else:
        raise Exception(f'Redis mode not supported: {_mode}')


def judgeExpInfo(run,start,end,judgeT,judgeRun):
    if end-start<10:
        return False
    if start-judgeT<5:
        return False
    if run==judgeRun:
        return False
    return True

if __name__=="__main__":
    confFile = "conf.json"
    with open(confFile,"r") as json_file:
        conf=json.load(json_file)

    rds=getRedisHelper(conf["redis"]) 
    path="/mpi/expRecInfo"

    judgeT0=0
    judgeRun=1
    print("hello")

    while True:
        expInfo = rds.read(path)
        expInfo=json.loads(bytes.decode(expInfo))
        if expInfo is None:
            print("This is None!")
            time.sleep(10)
        else:
            startT0=int((expInfo["startPulseId"]))
            endT0=int((expInfo["endPulseId"]))
            runNo=expInfo["runNo"][3:]
            runNo=int(runNo)
            judge=judgeExpInfo(runNo,startT0,endT0,judgeT0,judgeRun)
            if judge:
                with open("expInfo.txt","a") as f0:
                    f0.write("%d %d %d"%(runNo,startT0,endT0))
                    f0.write("\n")
                f0.close()
                judgeT0=startT0
                judgeRun=runNo
                time.sleep(20)
            else:
                time.sleep(20)
