import h5py
import datetime

def writeGroup(parent,name,ntype):
    grp = parent.create_group(name)
    grp.attrs["NX_class"] = ntype
    return grp

class CSNSNexus():
    def __init__(self):
        pass


    def writeFileAttrs(self,entry,fName):
        entry.attrs["default"]="entry"
        entry.attrs["file_name"]=fName
        timestamp = str(datetime.datetime.now())
        entry.attrs["file_time"]=timestamp
        entry.attrs["NeXus_Version"]="4.3.0"
        entry.attrs["HDF5_Version"]="1.8.12"


    def createBasicFramework(self,entry):
        root = writeGroup(entry,"csns","NXentry")
        grp = writeGroup(root,"instrument","NXinstrument")
        grp = writeGroup(root,"histogram_data","NXcollection")
        grp = writeGroup(root,"event_data","NXcollection")
        grp = writeGroup(root,"logs","NXcollection")
        grp = writeGroup(root,"process","NXprocess")
        grp = writeGroup(root,"user","NXuser")


    def writePublic(self,entry,dic):
        for key in dic:
             entry["/csns"].create_dataset(key, data = dic[key])

    def writePCPublic(self,entry,value):
        entry["/csns"].create_dataset("proton_charge",data=str(value))

    def writeInstrument(self):
        pass


    def writePCLog(self,entry,tai,pc):
        grp=entry["/csns/logs"]
        size=pc.shape
        grp.create_dataset("proton_charge",size,dtype='float32',data=pc)
        grp.create_dataset("utc_tai",size,dtype='int64',data=tai)

    def createModule(self,entry,module):
        son = writeGroup(entry["/csns/instrument"],module,"NXdetector")
        son = writeGroup(entry["/csns/histogram_data"],module,"NXdata")
        son = writeGroup(entry["/csns/event_data"],module,"NXdata")

    def writeModuleInfo(self,entry,module,pixels,tofs):
        grp=entry["/csns/instrument/"+module]
        size=pixels.shape
        grp.create_dataset("pixel_id",size,dtype='int64', data=pixels)
        size=tofs.shape
        grp.create_dataset("time_of_flight",size,dtype='int32', data=tofs)

    def createHistDataPointer(self,entry,module,pidNums,tofNums):
        return entry["/csns/instrument/"+module].create_dataset("histogram_data", (pidNums,tofNums), dtype='int32')

    def createEvtDataPointer(self,entry, module,chunkSize,compression):
        p_pid=entry["/csns/instrument/"+module].create_dataset("event_pixel_id", (chunkSize, ), maxshape=(None, ), dtype='int64', compression=compression, chunks=(chunkSize, ))
        p_tof=entry["/csns/instrument/"+module].create_dataset("event_time_of_flight", (chunkSize, ), maxshape=(None, ), dtype='float32', compression=compression, chunks=(chunkSize, ))
        p_pulse=entry["/csns/instrument/"+module].create_dataset("event_pulse_time", (chunkSize, ), maxshape=(None, ), dtype='int64', compression=compression, chunks=(chunkSize, ))
        return p_pid,p_tof,p_pulse


    def writeEvtLink(self,entry,module):
        entry["/csns/event_data/"+module]["event_time_of_flight"]=h5py.SoftLink("/csns/instrument/"+module+"/event_time_of_flight")
        entry["/csns/event_data/"+module]["event_pixel_id"]=h5py.SoftLink("/csns/instrument/"+module+"/event_pixel_id")
        entry["/csns/event_data/"+module]["event_pulse_time"]=h5py.SoftLink("/csns/instrument/"+module+"/event_pulse_time")

    def writeHistLink(self,entry,module):
        entry["/csns/histogram_data/"+module]["histogram_data"]=h5py.SoftLink("/csns/instrument/"+module+"/histogram_data")
        entry["/csns/histogram_data/"+module]["time_of_flight"]=h5py.SoftLink("/csns/instrument/"+module+"/time_of_flight")


    

