
from iMACS.IO import ManagedHistRedis, ManagedRedis
from iMACS.Config import HistConfig, RedisConfig, RedisRWConfig, ConfigGenerator, ConfigHelper
import json, logging
from time import sleep
import numpy as np

logging.basicConfig(
    format='%(asctime)s %(levelname)-4s %(message)s',
    level=logging.INFO,
    datefmt='%Y-%m-%d %H:%M:%S')

#redis
rdisConfObj=RedisConfig()
rdisConfObj.set(class_name='ManagedRedis')
rdisConfObj.set(password='sanlie_123') #set a single parameter
rdisConfObj.set(master_name='mpi_redis_master', db=0) #or multiple parameters
servers= [("10.1.37.241","26379"),("10.1.37.246","26379"),("10.1.37.247","26379")]
rdisConfObj.set(servers=servers, socket_timeout=100)

rds = eval(rdisConfObj.getDict().get('class_name'))(rdisConfObj.getDict())

floatpath='/mpi/floatpath'
rds.incrbyfloat(floatpath, 1.5)
rds.incrbyfloat(floatpath, 1.5)

print(f'floatpath {rds.read(floatpath)}')
print('Completed!')
