import numpy as np
import h5py
import time
import baseComp
import baseOP
import json
import sys

if __name__=="__main__":
    confFile = "conf.json"
    with open(confFile,"r") as json_file:
        conf=json.load(json_file)

    xmlPath="/home/da/iMACS/writeIDF/idf"
    dataPath="/home/da/"+sys.argv[1]
    #baseOP.createDir(dataPath)
    moduleInfo={}
    for _item in conf['modules']['detector_modules']:
        if _item.get('enabled') is not None:
            if _item['enabled'] == False:
                print(f'{_item["topic"]} is not enabled, skip.')
                continue
        length=int(_item["module_length"])
        pidNums=length/5*8
        moduleInfo[baseOP.getModuleName(_item)]=pidNums
    
    be=time.time()
    nxsFile=dataPath+"/detector.nxs"
    f_nxs=h5py.File(nxsFile,"w")
    nf=baseComp.nxsWrite(f_nxs)
    nf.createBasicFramework()
    nf.writeFileAttrs(nxsFile)
    pubInfo={"start_time_utc":"2021-01-01 00:00:00","end_time_utc":"2021-01-02 00:00:00","start_time_tai":"123456789","end_time_tai":"123456789","beamline":"BL15","run_no":"TEST0001"}
    nf.writePublicData(pubInfo)

    tofs=[]
    for i in range(2501):
        tofs.append(i*16)
    tofs=np.array(tofs)

    for name in moduleInfo:
        #print(name,moduleInfo[name])
        nf.createModule(name)
        f0=h5py.File(dataPath+"/"+name+".nxs","r")
        tof = f0["/csns/instrument/"+name+"/event_time_of_flight"]
        pid = f0["/csns/instrument/"+name+"/event_pixel_id"]
        pulse = f0["/csns/instrument/"+name+"/event_pulse_time"]
        f_nxs["/csns/instrument/"+name].create_dataset("event_time_of_flight",tof.shape,dtype=tof.dtype,compression='gzip',data=tof)
        f_nxs["/csns/instrument/"+name].create_dataset("event_pulse_time",pulse.shape,dtype=pulse.dtype,compression='gzip',data=pulse)
        f_nxs["/csns/instrument/"+name].create_dataset("event_pixel_id",pid.shape,dtype=pid.dtype,compression='gzip',data=pid)
        pids=np.arange(moduleInfo[name])
        nx=int(moduleInfo[name]/8)
        pids=pids.reshape(nx,8)
        nf.writePid(name,pids,"gzip")
        nf.writeTof(name,tofs,"gzip")
        nf.writeEventLink(name)
        f0.close()
        
    f_nxs.close()
    print(time.time()-be," seconds!")
