import baseOP
import reckafka
import datetime
import json
import os
import Data.Detector.EventData
import sys

if __name__ == "__main__":
    with open("./jsonFile/conf_modules2.json","r") as json_file:
        dic = json.load(json_file)
    moduleList=dic["moduleList"]
    confFile = "./jsonFile/conf_kafka_evt.json"
    offsetTime=int(sys.argv[1])
    #bp=baseOP.timeConvert()
    #startTime="2020-12-20T00:00:00"
    #endTime="2020-12-27T00:00:00"
    #startT0=bp.local2PulseId(startTime)
    #endT0=bp.local2PulseId(endTime)
    #startT0=204769306
    #endT0=204818306
    #xmlPath="/home/dur/git/iMACS/recnxs/writeIDF/idf"
    for num in moduleList:
        moduleName="Module"+str(num)[-2:]
        bankName="Bank"+str(num)[1:3]
        topic = 'BL16-Detector-'+bankName+'-'+moduleName+'-EventData'
        kf = baseOP.kafkaIO(confFile,topic)
        consumer = kf.createKafkaConsumer(offsetTime)
        for msg in consumer:
            _data = Data.Detector.EventData.EventData.GetRootAsEventData(msg.value, 0)
            evt = _data.TofLength()
            print("offset hours: ",offsetTime," pulseID: ",_data.PulseId(),"evtnum: ", evt)
            #break
        consumer.close()





