import pathlib
import os
import json

class ConfHelper:
    def __init__(self, file_path=None):
        self.file_path = file_path
        self._conf_file = self._determinate_conf_file()
        self._conf = self._get_conf()

    def _determinate_conf_file(self):
        if self.file_path is not None:
            _path = pathlib.Path(self.file_path).expanduser().resolve()
            if _path.is_file():
                return _path.as_posix()
            else:
                raise Exception(f'File not exist: {file_path}')

        _base = pathlib.Path(__file__).resolve().parent.parent.parent
        _confF = pathlib.Path.joinpath(_base, 'conf/conf.json')
        if _confF.is_file():
            return _confF.as_posix()

        raise Exception('No conf.json found')

    def _get_conf(self):
        with open(self._conf_file, 'r') as _f:
            return json.load(_f)

    def get_conf_file(self):
        return self._conf_file

    def get_conf(self):
        return self._conf

    def write_conf_to_redis(self, redisHelper, key, conf):
        return redisHelper.write(key, json.dumps(conf))

    def get_conf_from_redis(self, redisHelper, key):
        return json.loads(redisHelper.read(key))
