import reconst
from kafkaHelper import pulseId_time
import IOHelper
import sys
import os
from IO.Kafka import getDetectorData, getGlobalData, KafkaGrabber
import subprocess
import time
import math


def getExpLogFromCXX(path1,path2):
    while True:
        _cmd="scp -r "+path1+" "+path2
        subprocess.check_call(_cmd, shell=True)
        time.sleep(10)

def getSegmentInfo(recConf, runno):
    fname=recConf["local_expinfo_path"]+"/"+runno
    expInfo=IOHelper.getConf(fname)
    segHour=recConf["segmentHours"]
    step=3600*25*segHour
    t1=expInfo["startPulseId"]
    t2=expInfo["endPulseId"]
    bins=math.ceil((t2-t1)*1.0/step)
    binList=[]
    t1List=[]
    t2List=[]
    for i in range(bins):
        binList.append(i)
        startT=t1+step*i
        t1List.append(startT)
        if startT+step<t2:
            endT=startT+step
        else:
            endT=t2
        t2List.append(endT)
    return binList, t1List, t2List

class task_hist_rec():
    def __init__(self,runno,conf):
        self.runno = runno
        self.conf = conf
        self.recConf=self.conf["rec_configure"]
        self.rawPath=self.recConf["rawdata_path"]+"/"+runno
        self.tofs=self.recConf["tofbins"]
        self.evtStep=self.recConf["evtStep"]

    def recHist(self,name,indexList):
        histNxs=reconst.recHist(name,self.rawPath,self.tofs,self.evtStep)
        histNxs.fillHist(indexList)
        histNxs.closeNXS()
        print("finish hist for ",name)


    def getTasks(self):
        allModules=IOHelper.getModulesConf(self.conf)
        binList,_,_=getSegmentInfo(self.recConf, self.runno)
        tasks={}
        for taskName in allModules:
            tasks[taskName]=[self.recHist,(taskName,binList)]
        return tasks

class task_evt_rec():
    def __init__(self,runno,conf):
        self.runno = runno
        self.conf = conf
        self.recConf=self.conf["rec_configure"]
        self.rawPath=self.recConf["rawdata_path"]+"/"+runno
        self.chunksize=self.recConf["chunksize"]
        self.cmpr=self.recConf["compression"]
        if os.path.exists(self.rawPath):
            pass
        else:
            os.mkdir(self.rawPath)

    def getOffset(self,pulseId):
        P2T = pulseId_time(self.conf["modules"]["global_modules"][0])
        return (P2T.getOffset(pulseId))

    def recEvt(self,module_conf,indexList,startT0List,endT0List):
        name=IOHelper.getModuleName(module_conf)
        for i in indexList:
            filename=self.rawPath+"/"+name+"_evt_"+str(i)+".nxs"
            t1 = startT0List[i]
            t2 = endT0List[i]
            offset = self.getOffset(t1)
            task = KafkaGrabber(module_conf,offset)
            consumer=task.getKafkaConsumer()
            evtNxs=reconst.recEvt(name,filename,self.chunksize,self.cmpr)
            evtNxs.initEvtParams()
            for msg in consumer:
                pulseId, tofs, pids = getDetectorData(msg)
                finish = evtNxs.fillEvt(pulseId,tofs,pids,t1,t2,self.chunksize)
                if finish:
                    break
            consumer.close()
            evtNxs.closeNXS()
            print("finish evt for ",name, i)

    def getTasks(self):
        allModules=IOHelper.getModulesConf(self.conf)
        binList,startList,endList=getSegmentInfo(self.recConf, self.runno)
        tasks={}
        for taskName in allModules:
            tasks[taskName]=[self.recEvt,(allModules[taskName],binList,startList,endList)]
        return tasks 



