from IO.RedisHelper import RedisHelper
import json
import os

def getRedisHelper(redis_conf):
    _mode = redis_conf['mode'].lower()
    _password = redis_conf['password']
    _servers = []
    for _item in redis_conf['servers']:
        _servers.append((_item['host'], _item['port']))
    if _mode == 'standalone':
        return RedisHelper(_servers[0], _password, 10)
    elif _mode == 'sentinel':
        return RedisHelper(_servers, _password, 10, master_name=redis_conf['master_name'])
    else:
        raise Exception(f'Redis mode not supported: {_mode}')

def getModuleName(module_conf):
    _topic = module_conf['topic']
    num=_topic.find("Monitor")
    if num==-1:
        num=_topic.find("Bank")
        _p="module1"+_topic[num+4:num+6]
        num=_topic.find("Module")
        _p+=_topic[num+6:num+8]
    else:
        _p="monitor"+_topic[num+7:num+9]
    return _p

def getModulesConf(conf):
    moduleDict={}
    nameList=["detector_modules","monitor_modules"]
    for name in nameList:
        #try:
        for _item in conf['modules'][name]:
            if _item.get('enabled') is not None:
                if _item['enabled'] == False:
                    print(f'{_item["topic"]} is not enabled, skip.')
                    continue
                if _item["data_type"] == "event":
                    mname = getModuleName(_item)
                    moduleDict[mname]=_item
        #except:
        #    pass
    return moduleDict

def getConf(fname):
    judge=os.path.isfile(fname)
    if judge:
        with open(fname, 'r') as _f:
            return json.load(_f)
    else:
        print("can't find file")
        return 0

def getRunList2Rec(rec_conf):
    recList=[]
    minRun=rec_conf["minRun"]
    cmpPath=rec_conf["local_completeinfo_path"]
    logPath=rec_conf["local_expinfo_path"]
    try:
        complete=os.listdir(cmpPath)
    except:
        os.mkdir(cmpPath)
        complete=[]
    try:
        explog=os.listdir(logPath)
    except:
        os.mkdir(logPath)
        explog=[]
    for item in explog:
        if item[:3]=="RUN" and item not in complete:
            if int(item[-7:])>minRun:
                recList.append(item)
    return recList

