from .Task import Task
import re,time,logging
from iMACS.IO import ManagedRedisPeriodicRW
from iMACS.Config import ConfigHelper
from time import sleep
import numpy as np
import json, logging
import time

progress_path = "/mpi/imacs/progress"
end_path = "/mpi/imacs/last_run"
beam_time_path = "/mpi/imacs/beamtime"

class ManagedRedisExpCfg(Task, ManagedRedisPeriodicRW):
    def __init__(self, cfg, sharedControl, sharedNumHit, sharedAccumulated, lastExitCode=0):
        Task.__init__(self, sharedControl, sharedNumHit, sharedAccumulated, None, None, lastExitCode)
        self.cfghelp=ConfigHelper(cfg)
        self.curExpCfgDict = {} #current setting
        self.redisData = None #from user GUI
        self.dectCnt = 0.
        self.dectCntRate = 0.
        self.monitorCnt = 0.
        self.monitorCntRate = 0.
        self.runStartTime = None

        if type(cfg) is not dict:
            raise Exception('ManagedRedisExpCfg.__init__ cfg must be a dict')

    def realInit(self):
        if not self.init:
            ManagedRedisPeriodicRW.__init__(self, self.cfghelp.cfg)
            self.init = True

    def realRun(self):
        pass

    def startRun(self):
        logging.info(f'run started: {self.redisData}')
        with self.accumulated.get_lock():
            self.accumulated.value = 0

        with self.numhit.get_lock():
            self.numhit.value = 0

        with self.control.get_lock():
            self.control.value = 1

        self.runStartTime=time.time()
        #fixme: write database

    def stopRunClearData(self):
        logging.info('clearing run data')
        #let other component to act
        with self.control.get_lock():
            self.control.value = 2

        self.dectCnt = 0.
        self.dectCntRate = 0.
        self.monitorCnt = 0.
        self.monitorCntRate = 0.

        sleep(1) #fixme: gives 1 sec. to act

        with self.control.get_lock():
            self.control.value = 0

        with self.accumulated.get_lock():
            self.accumulated.value = 0

        with self.numhit.get_lock():
            self.numhit.value = 0



        #fixme: write database

    def pauseRun(self):
        if len(self.curExpCfgDict)!=0:
            logging.info('run paused')
        with self.control.get_lock():
            self.control.value = 0

        #fixme: write database

    def updateRunStatistics(self):
        if self.control.value==1:
            self.dectCnt = self.numhit.value
            self.monitorCnt = self.accumulated.value
            temp = time.time()-self.runStartTime
            if temp > 0:
                self.dectCntRate = self.dectCnt/temp
                self.monitorCntRate = self.monitorCnt/temp

    def run(self):
        self.realInit()
        self.startPeriodicRW()
        while True:
            sleep(1)
            #Pause run
            if self.redisData is None or self.redisData==b'null':
                self.pauseRun()
                continue

            runInfo = json.loads(self.redisData.decode())

            #when first start, curExpCfgDict is empty
            #assign it the runinfo to avoid starting this run
            if len(self.curExpCfgDict)==0:
                self.curExpCfgDict=runInfo
                continue

            #start new run
            if runInfo.get('runNo') != self.curExpCfgDict.get('runNo'):
                self.curExpCfgDict=runInfo
                self.stopRunClearData()
                self.startRun()

            else:
                self.updateRunStatistics()
