from mantid.simpleapi import *
import threading
import numpy as np
import time

class moduleIO(threading.Thread):
    def __init__(self,neonRedis, refreshtime, module,pidNum,tofbins):
        super(moduleIO, self).__init__()

        self.refreshtime=refreshtime
        self.neonRedis=neonRedis
        self.module=module
        self.pidNum=pidNum
        self.histPath="/MPI/workspace/detector/"+self.module+"/value"
        #self.histPath="/MPI/workspace/detector/"+self.module+"/value_old"
        self.instPath="../writeIDF/idf/MPI_Definition_"+self.module+".xml"
        self.sendPath="/mpi/mantid/"+self.module
        self.tofs=[]
        self.tofbins=tofbins
        step=40000/tofbins
        for i in range(tofbins):
            self.tofs.append(i*step)
        self.tofs=np.array(self.tofs)
       

    def processWS(self):
        CreateWorkspace(OutputWorkspace=self.module, DataX=self.tofs, DataY=self.value, NSpec=self.pidNum, UnitX='TOF', VerticalAxisUnit='SpectraNumber')
        LoadInstrument(Workspace=self.module, Filename=self.instPath, RewriteSpectraMap='True')
        ConvertUnits(InputWorkspace=self.module, OutputWorkspace=self.module+'_w', Target='Wavelength', EMode='Elastic', AlignBins = True)
        #SumSpectra(InputWorkspace=self.module+'_w', OutputWorkspace=self.module+'_w1')
        #ConvertToPointData(InputWorkspace=self.module+'_w1', OutputWorkspace=self.module+'_w1')
        CropWorkspace(InputWorkspace=self.module+"_w",OutputWorkspace=self.module+'_w', XMin=0.1, XMax=5.0)
        ConvertUnits(InputWorkspace=self.module+"_w", OutputWorkspace=self.module+'_d', Target='dSpacing', EMode='Elastic', AlignBins = True)
        SumSpectra(InputWorkspace=self.module+'_d', OutputWorkspace=self.module+'_d')
        ConvertToPointData(InputWorkspace=self.module+'_d', OutputWorkspace=self.module+'_d')
        SaveNexus(Filename=self.module+"_d.nxs",InputWorkspace=self.module+'_d')
        #SaveNexus(Filename=self.module+"_raw.nxs",InputWorkspace=self.module)
        ConvertUnits(InputWorkspace=self.module+"_d", OutputWorkspace=self.module+'_tof', Target='TOF', EMode='Elastic', AlignBins = True)
        ConvertUnits(InputWorkspace=self.module+"_d", OutputWorkspace=self.module+'_q', Target='MomentumTransfer', EMode='Elastic', AlignBins = True)

    def sendData(self,ws, dataX):
        name=mtd[ws]
        y=name.readY(0)
        x=name.readX(0)
        path=self.sendPath+"/"+dataX
        self.neonRedis.writeNumpyArray(path,x)
        path=self.sendPath+"/"+dataX+"_counts"
        self.neonRedis.writeNumpyArray(path,y)
        
    def sendXYimage(self):
        counts=[]
        xaxis=[]
        yaxis=[]
        name=mtd[self.module]
        for j in range(name.getNumberHistograms()):
            counts.append(sum(name.readY(j)))
            _pos=name.getDetector(j).getRelativePos()
            xaxis.append(_pos.X()*1000)
            yaxis.append(_pos.Y()*1000)
        xaxis=list(set(xaxis))
        yaxis=list(set(yaxis))
        xaxis.sort()
        yaxis.sort()
        nx=len(xaxis)
        ny=len(yaxis)
        xaxis=np.array(xaxis)
        yaxis=np.array(yaxis)
        self.neonRedis.writeNumpyArray(self.sendPath+"/xy_image/x",xaxis)
        self.neonRedis.writeNumpyArray(self.sendPath+"/xy_image/y",yaxis)
        _tmp=np.reshape(counts, (ny,nx))
        self.neonRedis.writeNumpyArray(self.sendPath+"/xy_image/value", _tmp)


    def process(self):
        try:
            tmp = self.neonRedis.readNumpyArray(self.histPath)
            tmp=tmp.T
            self.value=tmp
        except:
            self.value=np.zeros((self.pidNum,self.tofbins))
        #self.value=[]
        #print(type(self.value))
        #print(self.value.shape)
        #for i in range(800):
        #    for j in range(2500):
        #        self.value.append(int(tmp[i,j]))
        #print(self.value)
        self.processWS()
        self.sendData(self.module+"_d","d")
        self.sendData(self.module+"_q","q")
        self.sendData(self.module+"_tof","tof")
        self.sendXYimage()

    def run(self):
        while True:
            self.process()
            time.sleep(10)
