
from iMACS.IO import ManagedRedisPeriodicRW
from iMACS.Config import ConfigHelper

import collections
import numpy as np

class CircularBuffer:
    def __init__(self, cirBufSize=360*3, integralLength=250):
        self.cirBuf = collections.deque(maxlen=cirBufSize)
        for i in range(cirBufSize):
            self.cirBuf.append(0.)
        self.cirBufCnt = 0
        self.intLength = integralLength
        self.integral = 0

    def append(self, num):
        self.cirBufCnt += 1
        self.integral += num
        if self.cirBufCnt ==self.intLength:
            self.cirBuf.append(self.integral)
            self.integral = 0
            self.cirBufCnt = 0

    def getBuf(self):
        return np.array(self.cirBuf)

    def getSum(self):
        return np.array(self.cirBuf).sum()


#HistRedis.start() start periodic redis operations
#HistRedis.stop() stop the operation

# proton_charge_path = "/mpi/imacs/proton_charge" is self.getSum()
# current_pulse_path = "/mpi/imacs/pulse/current" is self.currentPulse
# proton_charge_hist = "/mpi/imacs/proton_charge_hist" is self.getBuf()

class ManagedCirBufRedis(CircularBuffer, ManagedRedisPeriodicRW):
    def __init__(self, cfg):
        CircularBuffer.__init__(self)
        ManagedRedisPeriodicRW.__init__(self, cfg)
        print('ManagedCirBufRedis', cfg)
        self.currentPulse = 0

    def addData(self, vecPulse, vecCharge):
        self.append(vecCharge.sum())
        self.currentPulse=vecPulse[-1]
