from IO.RedisHelper import RedisHelper
import sys
import json

def getRedisHelper(redis_conf):
    _mode = redis_conf['mode'].lower()
    _password = redis_conf['password']
    _servers = []
    for _item in redis_conf['servers']:
        _servers.append((_item['host'], _item['port']))

    if _mode == 'standalone':
        return RedisHelper(_servers[0], _password, 10)
    elif _mode == 'sentinel':
        return RedisHelper(_servers, _password, 10, master_name=redis_conf['master_name'])
    else:
        raise Exception(f'Redis mode not supported: {_mode}')


with open('redisConf.json',"r") as json_file:
    conf = json.load(json_file)
#num=sys.argv[1]
rds=getRedisHelper(conf)
#path="/MPI/workspace/detector/module"+str(num)+"/value"
#path="/mpi/mantid/module"+str(num)+"/d_counts"
#path="/MPI/workspace/monitor1/value"
path="/mpi/mantid/group10/raw/d_counts"
data=rds.readNumpyArray(path)
print(data.shape,data.sum())
