
from iMACS.Config import KafkaConfig, HistConfig, RedisConfig, RedisRWConfig, ConfigHelper
import json
import logging
class ConfigGenerator(ConfigHelper):
    def __init__(self):
        super().__init__({})
        self.keyMap={}
        self.keyMap['Kafka'] = KafkaConfig
        self.keyMap['Histogram'] = HistConfig
        self.keyMap['Redis'] = RedisConfig
        self.keyMap['RedisRW'] = RedisRWConfig


    def reset(self):
        self.cfg={}

    def addConfig(self, cfgobj):
        supportedType = False
        logging.info(f'adding {type(cfgobj)} object')
        for key, objectType in self.keyMap.items():
            if type(cfgobj) is objectType:
                if self.getValue('Managed') is None:
                    self.cfg['Managed'] = []
                self.cfg['Managed'].append(cfgobj.getDict())
                supportedType=True
                break
        if not supportedType:
            raise Exception(f'ConfigGenerator unsupported {type(cfgobj)}')

    def getConfigDict(self):
        return self.cfg

    def getConfigJson(self):
        return json.dumps(self.cfg, indent = 2)

    def saveAs(self, fileName):
        with open(fileName, 'w') as outfile:
            json.dump(self.cfg, outfile, indent = 2)
