#!/usr/bin/env python3

from iMACS.IO import ManagedHistRedis, ManagedRedis
from iMACS.Config import HistConfig, RedisConfig, RedisRWConfig, ConfigGenerator, ConfigHelper
import json, logging
from time import sleep

logging.basicConfig(
    format='%(asctime)s %(levelname)-4s %(message)s',
    level=logging.INFO,
    datefmt='%Y-%m-%d %H:%M:%S')

gen = ConfigGenerator()

#redis
rdisConfObj=RedisConfig()
rdisConfObj.set(class_name='ManagedRedis')
rdisConfObj.set(password='sanlie_123') #set a single parameter
rdisConfObj.set(master_name='mpi_redis_master', db=0) #or multiple parameters
servers= [("10.1.37.241","26379"),("10.1.37.246","26379"),("10.1.37.247","26379")]
rdisConfObj.set(servers=servers, socket_timeout=100)
gen.addConfig(rdisConfObj)


bank=10
module=5
module_length=500

#histogram redis
rRW = RedisRWConfig()
rRW.set(class_name='None a class')
rRW.set(redis_info=rdisConfObj.getDict())
moduleID=int(1e5+bank*1e2+module)
rRW.set(redisPath=f'/MPI/workspace/detector/module{moduleID}/value')
rRW.set(mode='w')
rRW.set(asNumArray=True, update_interval_sec=2)

minPixelID= 1e8 + bank*1e6 + module * 1e4

#histogram
histCfgObj = HistConfig()
histCfgObj.set(class_name='ManagedHistRedis')
histCfgObj.set(xBinNum=2500)
histCfgObj.set(xmin=-0.5)
histCfgObj.set(xmax=40000-0.5)

histCfgObj.set(yBinNum=module_length)
histCfgObj.set(ymin=minPixelID+0.5)
histCfgObj.set(ymax=minPixelID+0.5+500)
histCfgObj.set(redis_readwrite=rRW.getDict())

gen.addConfig(histCfgObj)

fname='test_config.json'
gen.saveAs(fname)

chlp = ConfigHelper(fname)
cfgItems= chlp.getValue('Managed')
hr = eval(cfgItems[1].get('class_name'))(cfgItems[1])
hr.startPeriodicRW()
print('startPeriodicRW!')

for _ in range(10):
    hr.fill([10],[10])

print('finished filling!')

print(cfgItems[0])
rds = eval(cfgItems[0].get('class_name'))(cfgItems[0])

redBack = rds.readNumpyArray(f'/MPI/workspace/detector/module{moduleID}/value').sum()
print(f'read back is {redBack}')
hr.stopPeriodicRW()
print('Completed!')
