#!/usr/bin/env python3

from iMACS.IO import HistRedis
from iMACS.Config import HistConfig, RedisConfig, RedisRWConfig, ConfigGenerator
import json
from time import sleep


gen = ConfigGenerator()

#redis
rdisConfObj=RedisConfig()
rdisConfObj.set(password='sanlie_123') #set a single parameter
rdisConfObj.set(master_name='mpi_redis_master', db=0) #or multiple parameters
servers= [{
            "host": "10.1.37.241",
            "port": "26379"
        },
        {
            "host": "10.1.37.246",
            "port": "26379"
        },
        {
            "host": "10.1.37.247",
            "port": "26379"
        }]

rdisConfObj.set(servers=servers, socket_timeout=100)

bank=10
module=5
module_length=500

#read write of redis
rRW = RedisRWConfig()
rRW.set(redis_info=rdisConfObj.getDict())
moduleID=int(1e5+bank*1e2+module)
rRW.set(redisPath=f'/MPI/workspace/detector/module{moduleID}/value', mode='w')
rRW.set(asNumArray=True, update_interval_sec=2)

minPixelID= 1e8 + bank*1e6 + module * 1e4

#histogram
histCfgObj = HistConfig()
histCfgObj.set(xBinNum=2500)
histCfgObj.set(xmin=-0.5)
histCfgObj.set(xmax=40000-0.5)

histCfgObj.set(yBinNum=module_length)
histCfgObj.set(ymin=minPixelID+0.5)
histCfgObj.set(ymax=minPixelID+0.5+500)
histCfgObj.set(redis_readwrite=rRW.getDict())

gen.addConfig(histCfgObj)
print(gen.getConfigDict())

hr = HistRedis(gen.getConfigDict())
hr.start()

sleep(10)
hr.stop()
