from iMACS.Config import ConfigHelper
from iMACS.IO import ManagedRedis
import epics
import time, threading, logging

class ValidRange():
    def __init__(self, valid_range):
        self.min = None
        self.max = None
        self.list =None
        if len(ValidRange)==2:
            self.min = valid_range[0]
            self.max = valid_range[1]
        else:
            self.list = valid_range

    def __contains__(self, value):
        if self.list is None:
            return value > self.min && value < self.max
        else:
            return value in self.list


class iPV(epics.PV):
    #active is shared memory 0(false) or 1(true)
    def __init__(self, pv_name, alias, rw_mode, redis_path, valid_range, veto, active=False):
        super().__init__(pv_name) #, connection_callback=self.on_connect_change)
        add_callback(self.callBack)
        slef.alias = alias
        self.rw_mode = rw_mode
        self.redis_path = redis_path
        self.veto = veto
        self.active=active
        self.valid_range = ValidRange(valid_range)

    def __str__(self):
        return ca.message(self.status))

    def callBack(self, pvname, value=None, char_value=None, state=None, timestamp=None, **kw):
        if self.veto:
            if value in valid_range:
                self.active=True
            else:
                self.active=False


class ManagedEpics(ManagedRedis):
    def __init__(self, epicsCfg):
        ManagedRedis.__init__(self, epicsCfg)
        self.ipv_list=[]
        for aPV in epicsCfg:
            self.ipv_list.append(iPV(aPV['pv_name'], aPV['alias'], aPV['rw_mode'], aPV['redis_path'], aPV['valid_range'], aPV['veto']))

        # self.eDevice = epics.Device()
        # for aPV in epicsCfg:
        #     self.eDevice.add_pv(aPV['pv_name'], attr=aPV['alias'])
        #
        # for _item in temp_pvs:
        #     tempDevice.add_pv(_item['name'], attr=_item['alias'])
        #     if _item['direction'] == 'input':
        #         tempDevice.add_callback(_item['alias'], on_value_change)
        #         tenoDevuce.add_connection_callback
        # #tempDevice = epics.Device('EXP_IB1_MPI:SE:TEMP:', attrs=('SEStatus:bi', 'Status:bi'))
        # #tempDevice.put('set_val', 273.15, wait=True, timeout=10.0)
        # _s = time.time()
        # current_state = tempDevice.save_state()
        # #tempDevice.restore_state(current_state)
        # tempDevice.write_state('epics_state.txt', state=None)
        # tempDevice.read_state('epics_state.txt', restore=False)
