from iMACS.IO import ManagedRedis
from iMACS.Config import ConfigHelper
import time, threading, logging
#master_name, ip_port, socket_timeout, db,
#redisPath, mode, asNumArray, update_interval_sec

class  ManagedRedisPeriodicRW( ManagedRedis):
    def __init__(self, redisRWCfg):
        self.target = None
        if redisRWCfg is None:
            return
        super().__init__( redisRWCfg.get('redis_info'))
        cfg = ConfigHelper(redisRWCfg)

        self.target = cfg.getValue('target')
        if self.target is None or type(self.target) is not list:
            raise Exception(f'ManagedRedisPeriodicRW target setting error {self.target}')

        self.interval_sec = cfg.getValue('update_interval_sec')
        self.keepRunning = False
        self.lock = threading.Lock()

    def __del__(self):
        self.stopPeriodicRW()


    def startPeriodicRW(self):
        if self.target is not None:
            self.keepRunning = True
            self.periodictTask()

    def stopPeriodicRW(self):
        if self.target is not None:
            self.keepRunning = False


    def periodictTask(self):
        if self.target is not None:
            with self.lock:
                for sutff in self.target:
                    dpath = sutff['redisPath']
                    data = eval(sutff['data'])
                    mode = sutff['mode']
                    if mode == 'wnp':
                        self.writeNumpyArray(dpath,data)
                        logging.debug(f'periodictTask writing numpy array to {dpath}, sum is {data.sum()}')
                    elif mode == 'w':
                        self.write(dpath,data)
                        logging.debug(f'periodictTask writing to {dpath}, data is {data}')
                    elif mode == 'incrbyfloat':
                        self.incrbyfloat(dpath,data)
                        logging.debug(f'periodictTask increased {dpath} by {data}')
                    elif mode == 'r':
                        self.redisData=self.read(dpath)
                        logging.debug(f'periodictTask reading {dpath} to {data}')
                    else:
                        raise Exception(f'ManagedRedisPeriodicRW unsuppored operation{mode}')

                if self.keepRunning:
                   threading.Timer(self.interval_sec, self.periodictTask).start()
