#!/usr/bin/env python3

from IO.Kafka import getDetectorData, getGlobalData, KafkaGrabber
from Utils.Histogram import Hist2D
from Tasks.TaskManager import TaskManager
from IO.RedisHelper import RedisHelper

from time import sleep
import multiprocessing as mp
import time
import numpy as np
import logging
import re
import sys

logging.basicConfig(level=logging.INFO)

def getRedisPath(conf):
    _topic = conf['topic']
    _pattern = '^BL16-Detector-Bank(\d{2})-Module(\d{2})-EventData$'
    _r = re.match(_pattern, _topic)
    _p = None
    if _r is not None:
        _p = '1' + _r.group(1) + _r.group(2)

    return '/MPI/workspace/detector/module' + _p + '/value'

def getModuleName(conf):
    _topic = conf['topic']
    _pattern = '^BL16-Detector-(Bank\d{2}-Module\d{2})-EventData$'
    _r = re.match(_pattern, _topic)
    _p = None
    if _r is not None:
        _p = _r.group(1)

    return _p

def getPixelIdBase(conf):
    _topic = conf['topic']
    _pattern = '^BL16-Detector-Bank(\d{2})-Module(\d{2})-EventData$'
    _r = re.match(_pattern, _topic)
    if _r is not None:
        _p = '1' + _r.group(1) + _r.group(2) + '0000'
        return int(_p)
    raise Exception(f'Cannot find pixel ID base for topic: {_topic}')

def onlineDetector(conf):
    print('onlineDetector is running')
    redisPath = getRedisPath(conf)
    ip_port = ('10.1.36.57', 6379)
    passwd = 'sanlie_123'
    appName = getModuleName(conf)

    rds= RedisHelper(ip_port, passwd, 10)

    _pixels = conf['module_length'] // 5 * 8
    _pixelIdBase = getPixelIdBase(conf)
    _lowId = _pixelIdBase + 1
    _highId = _pixelIdBase + _pixels

    tofBinSize = 2500
    pixBinSize = _pixels//2

    hist = Hist2D(tofBinSize, pixBinSize, [[0-0.5, 40000-0.5], [-0.5 + _lowId, _highId + 0.5]])
    task = KafkaGrabber(conf, 100000)
    consumer = task.getKafkaConsumer()
    dataType = task.getDataType()
    startTime = time.time()
    i = int(0)
    startPulseID = 0
    for msg in consumer:
        pulseId, tof, pid = getDetectorData(msg)

        if pulseId <= 160192644 - 25*60*60*2.7:
            continue
        if pulseId > 160192644:
            consumer.commit()
            consumer.close()
            break

        i += int(1)
        pulseStart = time.time()

        if startPulseID == 0:
            startPulseID=pulseId
        #print(pulseId, tof.shape, pid.min(), pid.max())

        if not tof.size * pid.size:
            logging.warning('data with zero size')
            continue
        if tof.size != pid.size:
            logging.warning('tof and pid arrays differ in size')
            continue

        if not hist.fill(tof, pid):
            print(tof)
            print(pid)
            print('tof type', type(tof), tof.size)
            print('pid type', type(pid), pid.size)
            print('tof range', tof.min(),tof.max())
            print('pid range', pid.min(),pid.max() )
            logging.warning('{} contains invalid data, range of tof(), range of pid{}'.format(\
                            appName, (tof.min(),tof.max()), (pid.min(),pid.max()) ))
            return

        pulseEnd=time.time()

        if i==int(2500):
            print(pulseId)
            i=int(0)
            rds.writeNumpyArray(redisPath, hist.hist)
            # data_back=rds.readNumpyArray(redisPath)
            # np.testing.assert_array_equal(hist.hist,data_back)
            # print('passed redis numpy read write test')
            redisTime=time.time()
            totEvent = hist.hist.sum()
            logging.info('pulse processing time {:5.2f}ms, histogram accumulated {}, rate {:5.2f}kHz, redis {:5.2f}ms'.format((pulseEnd-pulseStart)*1e3, totEvent, \
                          totEvent/((pulseId-startPulseID)*40.), 1e3*(redisTime-pulseEnd)  ))

def getModuleConfig():
    _conf={'global_modules':[{'data_type':'meta','bootstrap_servers':['10.1.29.120:9092'], 'auto_offset_reset':'earliest','group_id':'mpi_das', 'topic':'PulseBeam', 'enable_auto_commit': True, 'consumer_timeout_ms':60000}], 
            'detector_modules':[
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank10-Module05-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500}, 
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank10-Module04-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500}, 
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank10-Module03-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500},
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank10-Module02-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500}, 
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank05-Module05-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500}, 
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank05-Module04-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500}, 
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank05-Module03-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500}, 
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank05-Module02-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500}, 
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank07-Module04-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':300}, 
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank07-Module03-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':300}, 
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank07-Module02-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':300}, 
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank07-Module01-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':300}, 
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank09-Module03-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500}, 
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank09-Module02-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500},
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank06-Module03-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500},
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank06-Module02-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500},
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank04-Module04-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500},
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank04-Module03-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500},
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank03-Module04-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500},
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank03-Module03-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':500},
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank08-Module04-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':300},
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank08-Module03-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':300},
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank08-Module02-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':300}, 
        {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest', 'group_id':'das_test_online_new', 'topic':'BL16-Detector-Bank08-Module01-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':60000, 'module_length':300}]}

    return _conf

# onlineDetector(conf)

if __name__ == '__main__':
    conf = getModuleConfig()

    tasks = {}
    for _item in conf['detector_modules']:
        _taskName = 'DET-' + getModuleName(_item)
        tasks[_taskName] = [onlineDetector, (_item,)]

    if len(tasks) == 0:
        sys.exit(0)

    mp.set_start_method('fork')
    man = TaskManager(tasks)
    print("main thread sleeping")
    sleep(100000000)
    man.stopProc()
    print ('Main exit')
