#!/usr/bin/env python3

from IO.Kafka import getDetectorData, getGlobalData, KafkaGrabber
from Utils.Histogram import Hist2D
from Tasks.TaskManager import TaskManager
from IO.RedisHelper import RedisHelper

from time import sleep
import multiprocessing as mp
import time
import numpy as np
import logging

logging.basicConfig(level=logging.INFO)



def onlineDetector(conf):
    print('onlineDetector is running')
    redisPath='MPI/workspace/detector/module02/value'
    ip_port = ('10.1.36.57', 6379)
    passwd = 'sanlie_123'

    rds= RedisHelper(ip_port, passwd, 10)

    tofBinSize = 2500
    pixBinSize=480//2

    hist = Hist2D(tofBinSize, pixBinSize,[[0-0.5,40000-0.5],[103030001-0.5,103030001-0.5+480]])

    task = KafkaGrabber( conf=conf['detector_modules'][1])
    consumer = task.getKafkaConsumer()
    dataType = task.getDataType()
    startTime=time.time()
    i=int(0)
    for msg in consumer:
        i+=1
        pulseStart=time.time()
        pulseId, tofs, pids = getDetectorData(msg)
        # print(pulseId, tofs.shape, pids.min(), pids.max())
        hist.fill(tofs, pids)
        pulseEnd=time.time()
        totEvent = hist.hist.sum()
        if i==1000:
            i=0
            rds.writeNumpyArray(redisPath, hist.hist)
            data_back=rds.readNumpyArray(redisPath)
            np.testing.assert_array_equal(hist.hist,data_back)
            print('passed redis numpy read write test')
            logging.info('pulse processing time {}ms, histogram accumulated {}, rate {}Hz'.format((pulseEnd-pulseStart)*1e3, totEvent, totEvent/(pulseEnd-startTime)  ))

conf={'detector_modules':[{'data_type':'meta','bootstrap_servers':['10.1.29.120:9092'], 'auto_offset_reset':'earliest','group_id':'mpi_das', 'topic':'PulseBeam', 'enable_auto_commit': True, 'consumer_timeout_ms':5000}, {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest','group_id':'das_test', 'topic':'BL16-Detector-Bank07-Module02-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':5000}]}
# onlineDetector(conf)
if __name__ == '__main__':
    mp.set_start_method('fork')

    tasks = {'det': [onlineDetector, (conf,)]}
    man = TaskManager(tasks)
    print("main thread sleeping")
    sleep(100000000)
    man.stopProc()
    print ('Main exit')
