#!/usr/bin/env python3

from iMACS.Tasks import ManagedKafkaTask, ManagedRedisExpCfg
from iMACS.IO import ManagedRedis
from iMACS.Config import ConfigHelper
from iMACS.Tasks import TaskManager

import json,logging
import multiprocessing as mp
from time import sleep

logging.basicConfig(
    format='%(asctime)s %(levelname)-4s %(message)s',
    level=logging.INFO,
    datefmt='%Y-%m-%d %H:%M:%S')

from mpi_test_cfg import getConfigure

gen = getConfigure()

fname='test_config.json'
gen.saveAs(fname)

count=mp.Value('d',0)
countlock = mp.Lock()
sharedNumHit=(count, countlock)

charge=mp.Value('d',0)
chargelock = mp.Lock()
sharedCharge=(charge, chargelock)

ctrl=mp.Value('i', 0)
ctrlLock = mp.Lock()
control=(ctrl, ctrlLock)

tasks = {}

chlp = ConfigHelper(fname)
cfgItems= chlp.getValue('Managed')
print(cfgItems[1])
hist = eval(cfgItems[1].get('class_name'))(cfgItems[1], sharedControl = control, sharedNumHit=sharedNumHit )
hist.start()
print(f'started item1')

print(cfgItems[2])
ctl = eval(cfgItems[2].get('class_name'))(cfgItems[2], sharedControl = control, sharedNumHit=sharedNumHit, sharedAccumulated=sharedCharge )
ctl.start()
print(f'started item2')

while True:
    # with ctrlLock:
    #     if ctrl.value==1:
    #         ctrl.value = 0
    #     else:
    #         ctrl.value = 1
    print(f'ctrl {ctrl.value}, total {count.value}')
    sleep(1)
