from iMACS.IO import ManagedRedisPeriodicRW
from iMACS.Utils.Histogram import Hist2D
from iMACS.Config import ConfigHelper

class ManagedHist2D(Hist2D):
    def __init__(self, histCfg):
        cfgobj = ConfigHelper(histCfg)
        xBinNum = cfgobj.getValue('xBinNum' )
        yBinNum = cfgobj.getValue('yBinNum' )
        xmin = cfgobj.getValue('xmin' )
        xmax = cfgobj.getValue('xmax' )
        ymin = cfgobj.getValue('ymin' )
        ymax = cfgobj.getValue('ymax' )
        super().__init__(xBinNum , yBinNum, [[xmin, xmax], [ymin, ymax]])


#HistRedis.start() start periodic redis operations
#HistRedis.stop() stop the operation
class ManagedHistRedis(ManagedHist2D, ManagedRedisPeriodicRW):
    def __init__(self, cfg):
        #super().__init__(histCfg=cfg, redisRWCfg=cfg.get('redis_readwrite'))
        ManagedHist2D.__init__(self, cfg)
        ManagedRedisPeriodicRW.__init__(self, cfg.get('redis_readwrite'))
