import baseOP
import time
from IO.Kafka import getDetectorData, getGlobalData, KafkaGrabber
pulse_conf={
            "auto_offset_reset": "earliest",
                "bootstrap_servers": [
                    "10.1.29.120:9092"
                ],
                "comment": "Proton Charge",
                "consumer_timeout_ms": "inf",
                "data_type": "meta",
                "enable_auto_commit": True,
                "enabled": True,
                "group_id": "mpi_testdr",
                "topic": "PulseBeam"
        }



def getCurrentPulseId(off):
    task = KafkaGrabber(pulse_conf,off)
    consumer=task.getKafkaConsumer()
    for msg in consumer:
        pulseId,_,_,stamp=getGlobalData(msg)
        return pulseId,stamp[0]
    consumer.close()

def findPulseId(dt):
    tc=baseOP.timeConvert()
    curPid,stamp=getCurrentPulseId(1)
    texp=tc.local_to_utc_stamp(dt)
    offset = (stamp-texp)*25
    curPid,stamp=getCurrentPulseId(offset)
    local=tc.utc_stamp_to_local(stamp)
    return curPid, local


expTime="2021-01-26T19:28:00"
pulseId,exp=findPulseId(expTime)
print(pulseId, exp)
