#!/usr/bin/env python3

import sys
import time
from multiprocessing import Process, Pipe
import numpy as np

NUM = 100

def worker(conn):
    for task_nbr in range(NUM):
        conn.recv()
    sys.exit(1)


def main():
    data=np.random.rand(40, 40, 31)
    print(f'data size {data.size*8./2**20}MB')
    parent_conn, child_conn = Pipe(duplex=True)
    Process(target=worker, args=(child_conn,)).start()
    for num in range(NUM):
        message = parent_conn.send(data)


if __name__ == "__main__":
    start_time = time.time()
    main()
    end_time = time.time()
    duration = end_time - start_time
    msg_per_sec = NUM / duration

    print (f"Duration: {duration}")
    print (f"Messages Per Second: {msg_per_sec}")

# Took 10.86s.
