from .Task import Task
import re,time,logging
from iMACS.IO import ManagedRedisPeriodicRW
from iMACS.Config import ConfigHelper
from time import sleep
import numpy as np
import json, logging
import time, datetime
import os

end_path = "/mpi/imacs/last_run" #with control
runStartTime = "/mpi/imacs/start_time"
runEndTime = "/mpi/imacs/end_time"


class ManagedRedisExpCfg(Task, ManagedRedisPeriodicRW):
    def __init__(self, cfg, sharedControl, sharedNumHit, sharedAccumulated, sharedState, lastExitCode=0):
        Task.__init__(self, sharedControl, sharedNumHit, sharedAccumulated, sharedState, None, None, lastExitCode)
        self.cfghelp=ConfigHelper(cfg)
        self.curExpCfgDict = {} #current setting
        self.redisData = None #from user GUI
        self.dectCnt = 0.
        self.dectCntRate = 0.
        self.monitorCnt = 0.
        self.monitorCntRate = 0.
        self.runStartTime =  0
        self.elapsedTime=0
        self.runLength = 0.
        self.progress=0
        self.running = False
        self.pulseStart = 0
        self.pulseEnd = 0


        if type(cfg) is not dict:
            raise Exception('ManagedRedisExpCfg.__init__ cfg must be a dict')

    def realInit(self):
        if not self.init:
            ManagedRedisPeriodicRW.__init__(self, self.cfghelp.cfg)
            self.init = True

    def realRun(self):
        pass

    def startRun(self):
        curPulse = int(self.state.value)
        self.runLength = float(self.curExpCfgDict['endValue'])
        self.pulseStart = curPulse
        self.pulseEnd = curPulse + int(self.runLength*25)

        with open('runlog/running', 'a') as file:
            toDur=self.curExpCfgDict
            toDur['startPulseId']=self.pulseStart
            toDur['endPulseId']=self.pulseEnd
            file.write(json.dumps(toDur))

        logging.info(f'run started: {self.curExpCfgDict}')
        self.running=True
        with self.accumulated.get_lock():
            self.accumulated.value = 0

        with self.numhit.get_lock():
            self.numhit.value = 0

        with self.control.get_lock():
            self.control.value = 1

        self.runStartTime=time.time()

        now = datetime.datetime.now()
        self.write(runStartTime, str(now.strftime('%Y-%m-%d %H:%M:%S')))
        end = now + datetime.timedelta(seconds=self.runLength)
        self.write(runEndTime, str(end.strftime('%Y-%m-%d %H:%M:%S')))
        #fixme: write database


    def stopRunClearData(self):
        logging.info('clearing run data')
        self.running=False
        #let other component to act
        with self.control.get_lock():
            self.control.value = 2

        self.dectCnt = 0.
        self.dectCntRate = 0.
        self.monitorCnt = 0.
        self.monitorCntRate = 0.

        #update last_run
        self.write(end_path, self.curExpCfgDict['runNo'])

        sleep(3) #fixme: gives 3 sec. to act

        with self.control.get_lock():
            self.control.value = 0

        with self.accumulated.get_lock():
            self.accumulated.value = 0

        with self.numhit.get_lock():
            self.numhit.value = 0

    def endOfRunAction(self, runinfo, lastPulse=None):
        try:
            os.remove('runlog/running')
        except Exception as e:
            logging.info(e)
        logging.info('tried to remove runlog/running file')

        toDur = {}
        #toDur['runNo']=self.curExpCfgDict['runNo']
        toDur=runinfo
        toDur['startPulseId']=self.pulseStart
        if lastPulse is None:
            toDur['endPulseId']=self.pulseEnd
        else:
            toDur['endPulseId']=self.state.value
        with open('runlog/'+str(runinfo['runNo']), 'a') as file:
            file.write(json.dumps(toDur))
        logging.info('saved off-line json'.format(toDur))

    def pauseRun(self):
        if len(self.curExpCfgDict)!=0:
            logging.info('run stopped by user')
            if self.control.value == 1:
                self.endOfRunAction(self.curExpCfgDict, self.state.value)

        with self.control.get_lock():
            self.control.value = 0



        #fixme: write database

    def updateRunStatistics(self):
        if self.control.value==1:
            if self.runStartTime !=0:
                self.elapsedTime=time.time()-self.runStartTime
            else:
                self.elapsedTime=0
            self.dectCnt = self.numhit.value
            self.monitorCnt = self.accumulated.value
            if self.elapsedTime > 0:
                self.dectCntRate = self.dectCnt/self.elapsedTime
                self.monitorCntRate = self.monitorCnt/self.elapsedTime
                if self.runLength!=0.:
                    self.progress = self.elapsedTime/self.runLength*100
                else:
                    return
                if self.progress>100:
                    self.progress=100

    def run(self):
        self.realInit()
        self.startPeriodicRW()
        while True:
            sleep(1)
            #Pause run
            if self.redisData is None or self.redisData==b'null':
                self.pauseRun()
                continue

            runInfo = json.loads(self.redisData.decode())

            #when first start, curExpCfgDict is empty
            #assign it to runinfo to avoid starting this run
            if len(self.curExpCfgDict)==0:
                self.curExpCfgDict=runInfo
                continue



            #start new run
            if runInfo.get('runNo') != self.curExpCfgDict.get('runNo'):
                self.stopRunClearData()
                self.curExpCfgDict=runInfo
                logging.info('new config string',self.curExpCfgDict)
                self.startRun()
            #if overtime
            elif time.time()-self.runStartTime > self.runLength:
                logging.info('overtime')
                self.elapsedTime=self.runLength
                self.progress = 100
                if self.running==True:
                    self.stopRunClearData()
                    self.endOfRunAction(self.curExpCfgDict)
                else:
                    continue
            else:
                self.updateRunStatistics()
