import flatbuffers
from kafka import KafkaConsumer, TopicPartition
import iMACS.IO.Kafka.Data.Detector.EventData as EventData
import iMACS.IO.Kafka.Data.Global.MetaData as MetaData
import numpy as np

def getDetectorData(msg):
    data = EventData.EventData.GetRootAsEventData(msg.value, 0)
    pulseId = data.PulseId()
    tofs = data.TofAsNumpy()
    pids = data.PosAsNumpy()
    return pulseId, tofs, pids

def getGlobalData(msg):
    data = MetaData.MetaData.GetRootAsMetaData(msg.value, 0)
    pulseId = data.PulseId()
    # unused values are commented out
    #deviceId = data.DeviceId()
    #deviceName = data.DeviceName()
    value = data.ValueAsNumpy()
    #timeNano = data.TimeNanoAsNumpy()
    timeSecond = data.TimeSecondAsNumpy()
    return pulseId, np.sum(value), timeSecond
