import h5py
import time
import baseComp
import baseOP
import json
import sys

if __name__=="__main__":
    confFile = "conf.json"
    with open(confFile,"r") as json_file:
        conf=json.load(json_file)

    xmlPath="/home/da/iMACS/writeIDF/idf"
    dataPath="/home/da/"+sys.argv[1]
    #baseOP.createDir(dataPath)
    moduleList=[]
    for _item in conf['modules']['detector_modules']:
        if _item.get('enabled') is not None:
            if _item['enabled'] == False:
                print(f'{_item["topic"]} is not enabled, skip.')
                continue
        moduleList.append(baseOP.getModuleName(_item))
    
    be=time.time()
    nxsFile=dataPath+"/detector.nxs"
    f_nxs=h5py.File(nxsFile,"w")
    nf=baseComp.nxsWrite(f_nxs)
    nf.createBasicFramework()
    nf.writeFileAttrs(nxsFile)
    pubInfo={"start_time_utc":"2021-01-01T00:00:00","end_time_utc":"2021-01-02T00:00:00","start_time_tai":"123456789","end_time_tai":"123456789","beamline":"BL15","run_no":"TEST0001"}
    nf.writePublicData(pubInfo)

    for name in moduleList:
        nf.createModule(name)
        f0=h5py.File(dataPath+"/"+name+".nxs","r")
        tof = f0["/csns/instrument/"+name+"/event_time_of_flight"]
        pid = f0["/csns/instrument/"+name+"/event_pixel_id"]
        pulse = f0["/csns/instrument/"+name+"/event_pulse_time"]
        f_nxs["/csns/instrument/"+name].create_dataset("event_time_of_flight",tof.shape,dtype=tof.dtype,compression='gzip',data=tof)
        f_nxs["/csns/instrument/"+name].create_dataset("event_pulse_time",pulse.shape,dtype=pulse.dtype,compression='gzip',data=pulse)
        f_nxs["/csns/instrument/"+name].create_dataset("event_pixel_id",pid.shape,dtype=pid.dtype,compression='gzip',data=pid)
        nf.writeEventLink(name)
        f0.close()

    f_nxs.close()
    print(time.time()-be," seconds!")
