#!/usr/bin/env python3

from iMACS.Config import KafkaConfig, HistConfig, RedisConfig, RedisRWConfig, ConfigGenerator
import json


gen = ConfigGenerator()
#redis
rdisConfObj=RedisConfig()
rdisConfObj.set(password='sanlie_123') #set a single parameter
rdisConfObj.set(master_name='mpi_redis_master', db=0) #or multiple parameters
servers= [("10.1.37.241","26379"),("10.1.37.246","26379"),("10.1.37.247","26379")]

rdisConfObj.set(servers=servers, socket_timeout=100)
gen.addConfig(rdisConfObj)

#print(rdisConfObj.getJson())

################################################################
bank=10
module=5
module_length=500

#read write of redis
rRW = RedisRWConfig()
rRW.set(redis_info=rdisConfObj.getDict())
moduleID=int(1e5+bank*1e2+module)
rRW.set(redisPath=f'/MPI/workspace/detector/module{moduleID}/value', mode='w')
rRW.set(asNumArray=True, update_interval_sec=5)

minPixelID= 1e8 + bank*1e6 + module * 1e4

#histogram
histCfgObj = HistConfig()
histCfgObj.set(xBinNum=2500)
histCfgObj.set(xmin=-0.5)
histCfgObj.set(xmax=40000-0.5)

histCfgObj.set(yBinNum=module_length)
histCfgObj.set(ymin=minPixelID+0.5)
histCfgObj.set(ymax=minPixelID+0.5+500)
histCfgObj.set(redis_readwrite=rRW.getDict())

#kafka
kfkCfgObj = KafkaConfig()
kfkCfgObj.set(bootstrap_servers=[ \
                    "10.1.37.205:9092",\
                    "10.1.37.206:9092",\
                    "10.1.37.207:9092",\
                    "10.1.37.208:9092"])
kfkCfgObj.set(data_type='event')
kfkCfgObj.set(topic='BL16-Detector-tmp5-Bank10-Module05-EventData')
kfkCfgObj.set(group_id = 'durong_test', seek_type='beginning' )
kfkCfgObj.set(histogram=histCfgObj.getDict())

#print(kfkCfgObj.getJson())

gen.addConfig(kfkCfgObj)


print(gen.getConfigDict())
print(gen.saveAs('test_config.json'))
