from iMACS.Config import ConfigHelper
from iMACS.IO import ManagedRedis

import time, threading, logging
from epics import PV

class ValidRange():
    def __init__(self, valid_range):
        self.min = None
        self.max = None
        self.list =None
        print(valid_range, type(valid_range))
        if len(valid_range)==2:
            self.min = valid_range[0]
            self.max = valid_range[1]
        else:
            self.list = valid_range

    def __contains__(self, value):
        if self.list is None:
            return value >= self.min and value <= self.max
        else:
            return value in self.list


class iPV(PV):
    #active is shared memory 0(false) or 1(true)
    #fixme: data type of range
    def __init__(self, pv_name, alias, rw_mode, redis_path, write_value, valid_range, veto, redis_write, active=False):
        super().__init__(pv_name) #, connection_callback=self.on_connect_change)
        print('pv_name:', pv_name)
        # lcallback = lambda pvname, value, char_value, state, timestamp : self.callBack(self, pvname, value, char_value, state, timestamp)
        self.alias = alias
        self.rw_mode = rw_mode
        if self.rw_mode not in ['r', 'w']:
            raise RunTimeError('ManagedEpics rw_mode should be either w or r')
        self.redis_path = redis_path
        self.veto = veto
        self.write_value = write_value
        self.active=active
        self.valid_range = ValidRange(valid_range)
        self.redis_write = redis_write
        self.add_callback(self.callBack)
        if self.rw_mode=='w':
            self.value = self.write_value

    def __str__(self):
        return ca.message(self.status)

    def callBack(self, pvname, value=None, char_value=None, state=None, timestamp=None, **kw):
        if self.redis_path is not None:
            self.redis_write(self.redis_path, value)
            
        if self.veto:
            if value in self.valid_range:
                self.active=True
            else:
                self.active=False


class ManagedEpics(ManagedRedis):
    def __init__(self, epicsCfg, epics_list=[]):
        ManagedRedis.__init__(self, epicsCfg)
        self.ipv_list=[]
        for aPV in epics_list:
            self.ipv_list.append(iPV(aPV['pv_name'], aPV['alias'], aPV['rw_mode'], aPV['redis_path'], aPV['write_value'], aPV['valid_range'], aPV['veto'], self.write))
