from iMACS.IO import RedisHelper
from iMACS.Config import ConfigHelper
import time, threading
#master_name, ip_port, socket_timeout, db,
#redisPath, mode, asNumArray, update_interval_sec

class  RedisPeriodicRW( RedisHelper):
    def __init__(self, conf):
        print('RedisPeriodicRW.__int__')
        cfg = ConfigHelper(conf)
        super().__init__( master_name=cfg.getValue('redis_info', 'master_name'), \
                          ip_port=cfg.getValue('redis_info', 'servers'), \
                          socket_timeout=cfg.getValue('redis_info', 'socket_timeout'), \
                          db =cfg.getValue('redis_info', 'db'))

        self.redisPath = cfg.getValue('redisPath')
        self.mode = cfg.getValue('mode')
        if self.mode!='r' or self.mode!='w':
            raise Exception('mode should be either w or r')

        self.asNumArray = cfg.getValue('asNumArray')
        self.interval_sec = cfg.getValue('update_interval_sec')
        self.keepRunning = False
        self.lock = threading.Lock()


    def start(self):
        self.keepRunning = True
        self.periodictTask()

    def stop(self):
        self.keepRunning = False


    def periodictTask(self):
        with self.lock:
            if self.mode == 'r':
                if self.asNumArray:
                    self.target =  self.readNumpyArray(self.redisPath)
                else:
                    self.target =  self.read(self.redisPath)
            else:
                if self.asNumArray:
                    self.writeNumpyArray(self.redisPath, self.target )
                else:
                    self.write(self.redisPath, self.target)
        print(f'Integral is {self.target.sum()}')
        if self.keepRunning:
           threading.Timer(self.interval_sec, self.periodictTask)
