import re,time,logging


def getModuleName(conf):
    _topic = conf['topic']
    _pattern = '^BL16-Detector-(Bank\d{2}-Module\d{2})-EventData$'
    _r = re.match(_pattern, _topic)
    _p = None
    if _r is not None:
        _p = _r.group(1)

    return _p


def getRedisPath(conf):
    _topic = conf['topic']
    _pattern = '^BL16-Detector-Bank(\d{2})-Module(\d{2})-EventData$'
    _r = re.match(_pattern, _topic)
    _p = None
    if _r is not None:
        _p = '1' + _r.group(1) + _r.group(2)

    return '/MPI/workspace/detector/module' + _p + '/value'


def getPixelIdBase(conf):
    _topic = conf['topic']
    _pattern = '^BL16-Detector-Bank(\d{2})-Module(\d{2})-EventData$' #fixme: hard coded BL16
    _r = re.match(_pattern, _topic)
    if _r is not None:
        _p = '1' + _r.group(1) + _r.group(2) + '0000'
        return int(_p)
    raise Exception(f'Cannot find pixel ID base for topic: {_topic}')
