from mantid.simpleapi import *
import threading
import numpy as np
import time

class bankIO(threading.Thread):
    def __init__(self,neonRedis, refreshtime):
        super(bankIO, self).__init__()
        
        self.refreshtime=refreshtime
        self.neonRedis=neonRedis
        self.instPath="../writeIDF/idf/MPI_Definition_"+self.module+".xml"
        self.sendPath="/mpi/mantid/"
        self.dic={
                "bank5":[10502,10503,10504,10505],
                "bank6":[10602,10603],
                "bank7":[10701,10702,10703,10704],
                "bank8":[10801,10802,10803,10804],
                "bank9":[10902,10903],
                "bank10":[11002,11003,11004,11005]
                }
        self.bankList=[5,6,7,8,9,10]

    def mergeModules(self,bankname):
        num=0
        deltaD=[]
        maxD=[]
        minD=[]
        moduleList=self.dic[bankname]
        for mnum in moduleList:
            mname="module"+str(num)+"_d.nxs"
            LoadNexus(Filename=mname,OutputWorkspace='d')
            value=float(mtd['d'].readX(0)[1]-mtd['d'].readX(0)[0])
            maxD.append(float(mtd['d'].readX(0)[-1]))
            minD.append(float(mtd['d'].readX(0)[1]))
            deltaD.append(value)
            RenameWorkspace(InputWorkspace='d',OutputWorkspace=str(num))
            num+=1
        step_d=max(deltaD)
        dmin=min(minD)
        dmax=max(maxD)
        d_rebin=str(dmin)+','+str(step_d)+','+str(dmax)
        for j in range(num):
            if j==0:
                Rebin(InputWorkspace=str(j),OutputWorkspace='ans', Params=d_rebin)
            else:
                Rebin(InputWorkspace=str(j),OutputWorkspace='tmp', Params=d_rebin)
                mtd['ans']+=mtd['tmp']
            DeleteWorkspace(Workspace=str(j))
        ConvertToPointData(InputWorkspace='ans',OutputWorkspace=bankname)

    def process(self):
        for item in self.bankList:
            bname="bank"+str(item)
            pathname="group"+str(item).zfill(2)
            self.mergeModules(bname)
            self.sendBankData(bname,pathname,'d')
            ConvertUnits(InputWorkspace=bname,OutputWorkspace=bname+"_q",Target='MomentumTransfer')
            self.sendBankData(bname+"_q",pathname,'q')
            ConvertUnits(InputWorkspace=bname,OutputWorkspace=bname+"_tof",Target='TOF')
            self.sendBankData(bname+"_tof",pathname,'tof')


    def sendBankData(self,ws,gname,dataX):
        name=mtd[ws]
        y=name.readY(0)
        x=name.readX(0)
        path=self.sendPath+pathname+"/raw/"+dataX
        self.neonRedis.writeNumpyArray(path,x)
        path=self.sendPath+pathname+"/raw/"+dataX+"_counts"
        self.neonRedis.writeNumpyArray(path,y)

    def run(self):
        while True:
            self.process()
            time.sleep(5)
