from .Task import Task
import re,time,logging
from iMACS.IO import ManagedRedisPeriodicRW
from iMACS.Config import ConfigHelper
from time import sleep
import numpy as np
import json, logging

class ManagedRedisExpCfg(Task, ManagedRedisPeriodicRW):
    def __init__(self, cfg, sharedControl, sharedNumHit, sharedAccumulated, lastExitCode=0):
        Task.__init__(self, sharedControl, sharedNumHit, sharedAccumulated, None, None, lastExitCode)
        self.cfghelp=ConfigHelper(cfg)
        self.curExpCfgDict = {} #current setting
        self.redisData = None #from user GUI

        if type(cfg) is not dict:
            raise Exception('ManagedRedisExpCfg.__init__ cfg must be a dict')

    def realInit(self):
        if not self.init:
            ManagedRedisPeriodicRW.__init__(self, self.cfghelp.cfg)
            self.init = True

    def realRun(self):
        pass

    def startRun(self):
        logging.info(f'run started: {self.redisData}')
        with self.control[1]:
            self.control[0].value = 1
        #fixme: write database

    def stopRunClearData(self):
        logging.info('clearing run data')
        #let other component to act
        with self.control[1]:
            self.control[0].value = 2

        with self.accumulated[1]:
            self.accumulated[0].value = 0

        with self.numhit[1]:
            self.numhit[0].value = 0

        sleep(3) #fixme: gives 3 sec. to act
        #fixme: write database

    def pauseRun(self):
        if len(self.curExpCfgDict)!=0:
            logging.info('run paused')
        with self.control[1]:
            self.control[0].value = 0

        #fixme: write database


    def run(self):
        self.realInit()
        self.startPeriodicRW()
        while True:
            sleep(1)
            #Pause run
            if self.redisData is None:
                self.pauseRun()
                continue

            runInfo = json.loads(self.redisData.decode())
            #start new run
            if runInfo.get('runInfo') != self.curExpCfgDict.get('runInfo'):
                self.curExpCfgDict=runInfo
                self.stopRunClearData()
                self.startRun()
