#!/usr/bin/env python3

from IO.Kafka import getDetectorData, getGlobalData
from Tasks import KafkaDAQGrabber, KafkaMetaData

from Tasks.TaskManager import TaskManager
from IO.RedisHelper import RedisHelper, getRedisHelper
from IO.conf_helper import ConfHelper

from time import sleep
import multiprocessing as mp
import time
import numpy as np
import logging
import re
import sys

logging.basicConfig(
    format='%(asctime)s %(levelname)-8s %(message)s',
    level=logging.INFO,
    datefmt='%Y-%m-%d %H:%M:%S')

def getModuleName(conf):
    _topic = conf['topic']
    _pattern = '^BL16-Detector-(Bank\d{2}-Module\d{2})-EventData$'
    _r = re.match(_pattern, _topic)
    _p = None
    if _r is not None:
        _p = _r.group(1)
    return _p

from math import remainder

if __name__ == '__main__':
    sharedV=mp.Value('i',0)
    conf_helper = ConfHelper()
    conf = conf_helper.get_conf()
    redis_conf = conf['redis']
    rds = getRedisHelper(redis_conf)
    del conf['redis']
    _r = conf_helper.write_conf_to_redis(rds, '/MPI/conf', conf)
    if not _r:
        print('Write conf to Redis failed.')

    conf = conf_helper.get_conf_from_redis(rds, '/MPI/conf')

    tasks = {}
    for _item in conf['modules']['detector_modules']:
        if _item.get('enabled') is not None:
            if _item['enabled'] == False:
               print(f'{_item["topic"]} is not enabled, skip.')
               continue
       _taskName = 'DET-' + getModuleName(_item)
       grabber = KafkaDAQGrabber(sharedV, _item, redis_conf)
       tasks[_taskName] = grabber

    for _item in conf['modules']['detector_modules']:
        if _item.get('enabled') is not None:
            if _item['enabled'] == False:
                print(f'{_item["topic"]} is not enabled, skip.')
                continue
        proCharge = KafkaMetaData(sharedV, _item, redis_conf)
        tasks['Proton Charge'] = proCharge
    #0, idle
    #1, run
    #2, clear

    if len(tasks) == 0:
        sys.exit(0)

    print('Starting task manager')
    man = TaskManager(tasks)
    print("main thread sleeping")
    sleep(100000000)
    man.stopProc()
    print ('Main exit')
