import reconst
from kafkaHelper import pulseId_time
import IOHelper
import sys
import os
from IO.Kafka import getDetectorData, getGlobalData, KafkaGrabber
import subprocess
import time
import math
from Utils.TimeConvert import timeCvt

def getExpLogFromCXX(conf):
    path1=conf["rec_configure"]["cxx_remote_path"]
    path2=conf["rec_configure"]["cxx_local_path"]
    checkPath(path2)
    while True:
        _cmd="scp  "+path1+"/*"+" "+path2
        subprocess.check_call(_cmd, shell=True)
        #break
        time.sleep(10)

def getSegmentInfo(recConf, runno):
    fname=recConf["cxx_local_path"]+"/"+runno
    expInfo=IOHelper.getConf(fname)
    segHour=recConf["segmentHours"]
    step=3600*25*segHour
    t1=expInfo["startPulseId"]
    t2=expInfo["endPulseId"]
    bins=math.ceil((t2-t1)*1.0/step)
    binList=[]
    t1List=[]
    t2List=[]
    for i in range(bins):
        binList.append(i)
        startT=t1+step*i
        t1List.append(startT)
        if startT+step<t2:
            endT=startT+step
        else:
            endT=t2
        t2List.append(endT)
    return binList, t1List, t2List

def getPublicInfo(conf,runno):
    recConf=conf["rec_configure"]
    fname=recConf["cxx_local_path"]+"/"+runno
    expInfo=IOHelper.getConf(fname)
    t1=expInfo["startPulseId"]
    t2=expInfo["endPulseId"]
    P2T = pulseId_time(conf["modules"]["global_modules"][0])
    start_local = P2T.pulseId2Local(t1)
    end_local = P2T.pulseId2Local(t2)
    start_tai = P2T.local2utc(start_local)
    end_tai = P2T.local2utc(end_local)
    pubDict={"start_time_utc":[bytes(start_local,encoding="utf8")],
            "end_time_utc":[bytes(end_local,encoding="utf8")],
            "start_time_tai":[bytes(str(start_tai),encoding="utf8")],
            "end_time_tai":[bytes(str(end_tai),encoding="utf8")],
            "beamline":[b"BL16"],
            "run_no":[str.encode(runno)]}
    return pubDict

def checkPath(path):
    if os.path.exists(path):
        pass
    else:
        os.mkdir(path)


def sendData2TM(conf,runno):
    recConf=conf["rec_configure"]
    #cp xx runlog into detector file
    fname=recConf["cxx_local_path"]+"/"+runno
    detPath=recConf["detector_path"]+"/"+runno
    rawPath=recConf["rawdata_path"]+"/"+runno

    cmd="cp "+fname+" "+detPath
    subprocess.check_call(cmd, shell=True)

    cloudPath=recConf["cloud_path"]
    cmd="scp -r "+detPath+" "+cloudPath
    subprocess.check_call(cmd, shell=True)
    tmPath=recConf["tm_path"]
    cmd="scp -r "+detPath+" "+tmPath
    subprocess.check_call(cmd, shell=True)

    cmd="scp  "+rawPath+"/*evt*.nxs "+tmPath+"/"+runno
    subprocess.check_call(cmd, shell=True)

    f=open(runno, "w")
    f.close()
    cmpPath=recConf["complete_local_path"]
    checkPath(cmpPath)

    tmcmpPath=recConf["tm_runno_path"]
    cmd="cp "+runno+" "+cmpPath
    subprocess.check_call(cmd, shell=True)
    cmd="scp "+runno+" "+tmcmpPath
    subprocess.check_call(cmd, shell=True)
    cmd="rm -rf "+runno
    subprocess.check_call(cmd, shell=True)


class task_merge():
    def __init__(self,runno,conf):
        self.runno = runno
        self.conf = conf
        self.recConf=self.conf["rec_configure"]
        self.rawPath=self.recConf["rawdata_path"]+"/"+runno
        checkPath(self.recConf["detector_path"])
        self.nxsPath=self.recConf["detector_path"]+"/"+runno
        checkPath(self.nxsPath)

    def recNexus(self,moduleList):
        allNxs=reconst.recDetector(moduleList,self.rawPath, self.nxsPath)
        pubInfos=getPublicInfo(self.conf,self.runno)
        allNxs.writeWholeNexus(pubInfos,moduleList)


    def runTask(self):
        allModules=IOHelper.getModulesConf(self.conf)
        moduleList=allModules.keys()
        self.recNexus(moduleList)
        sendData2TM(self.conf,self.runno)


class task_hist_rec():
    def __init__(self,runno,conf):
        self.runno = runno
        self.conf = conf
        self.recConf=self.conf["rec_configure"]
        self.rawPath=self.recConf["rawdata_path"]+"/"+runno
        self.tofs=self.recConf["tofbins"]
        self.evtStep=self.recConf["evtStep"]

    def recHist(self,name,indexList):
        histNxs=reconst.recHist(name,self.rawPath,self.tofs,self.evtStep)
        histNxs.fillHist(indexList)
        histNxs.closeNXS()
        #print("finish hist for ",name)


    def getTasks(self):
        allModules=IOHelper.getModulesConf(self.conf)
        binList,_,_=getSegmentInfo(self.recConf, self.runno)
        tasks={}
        for taskName in allModules:
            tasks[taskName]=[self.recHist,(taskName,binList)]
        return tasks

class task_evt_rec():
    def __init__(self,runno,conf):
        self.runno = runno
        self.conf = conf
        self.recConf=self.conf["rec_configure"]
        checkPath(self.recConf["rawdata_path"])
        self.rawPath=self.recConf["rawdata_path"]+"/"+runno
        self.chunksize=self.recConf["chunksize"]
        self.cmpr=self.recConf["compression"]
        checkPath(self.rawPath)

    def getOffset(self,pulseId):
        P2T = pulseId_time(self.conf["modules"]["global_modules"][0])
        return (P2T.getOffset(pulseId))

    def recEvt(self,module_conf,indexList,startT0List,endT0List):
        name=IOHelper.getModuleName(module_conf)
        for i in indexList:
            filename=self.rawPath+"/"+name+"_evt_"+str(i)+".nxs"
            t1 = startT0List[i]
            t2 = endT0List[i]
            offset = self.getOffset(t1)
            task = KafkaGrabber(module_conf,offset)
            consumer=task.getKafkaConsumer()
            evtNxs=reconst.recEvt(name,filename,self.chunksize,self.cmpr)
            evtNxs.initEvtParams()
            for msg in consumer:
                pulseId, tofs, pids = getDetectorData(msg)
                finish = evtNxs.fillEvt(pulseId,tofs,pids,t1,t2,self.chunksize)
                if finish:
                    break
            consumer.close()
            evtNxs.closeNXS()
            #print("finish evt for ",name, i)

    def getTasks(self):
        allModules=IOHelper.getModulesConf(self.conf)
        binList,startList,endList=getSegmentInfo(self.recConf, self.runno)
        tasks={}
        for taskName in allModules:
            tasks[taskName]=[self.recEvt,(allModules[taskName],binList,startList,endList)]
        return tasks 

class task_online_module():
    def __init__(self,)

