#import mpiTask
from mpiTask import task_evt_rec, task_hist_rec,task_merge
import IOHelper
import time
import multiprocessing as mp
from Tasks.TaskManager import TaskManager

def runTasks(tasks):
    if len(tasks) == 0:
        sys.exit(0)
    man = TaskManager(tasks)
    while True:
        if len(man.processes)==0:
            man.stopProc()
            break
        time.sleep(30)


if __name__=="__main__":
    conf=IOHelper.getConf("./conf.json")
    recInfos=conf["rec_configure"]

    while True:
        #recList = mpiTask.getRunList2Rec(recInfos)
        recList = IOHelper.getRunList2Rec(recInfos)
        print("***********need to be reconstructed: ",recList)
        for runno in recList:
            be=time.time()
            #'''
            evtRec=task_evt_rec(runno,conf)
            tasks = evtRec.getTasks()
            runTasks(tasks)
            print("finish evt",runno, str(time.time()-be))
            
            histRec=task_hist_rec(runno, conf)
            tasks = histRec.getTasks()
            runTasks(tasks)
            print("finish hist",runno, str(time.time()-be))
            #'''
            detRec=task_merge(runno,conf)
            detRec.runTask()
            print("finish detector ",runno, str(time.time()-be))
        
        #break
        time.sleep(30)

