from IO.RedisHelper import RedisHelper
import json
import os

def getRedisHelper(redis_conf):
    mode = redis_conf['mode'].lower()
    password = redis_conf['password']
    servers = []
    for item in redis_conf['servers']:
        servers.append((item['host'], item['port']))
    if mode == 'standalone':
        return RedisHelper(servers[0], password, 10)
    elif mode == 'sentinel':
        return RedisHelper(servers, password, 10, master_name=redis_conf['master_name'])
    else:
        raise Exception(f'Redis mode not supported: {_mode}')

def getModuleBankName(module_conf):
    topic = module_conf['topic']
    num=topic.find("Monitor")
    if num==-1:
        num=topic.find("Bank")
        b=topic[num:num+6].lower()
        p="module1"+topic[num+4:num+6]
        num=topic.find("Module")
        p+=topic[num+6:num+8]
    else:
        p="monitor"+topic[num+7:num+9]
        b=topic[num:num+9].lower()
    return _p

def getModulesConf(conf):
    moduleDict={}
    nameList=["detector_modules","monitor_modules"]
    for name in nameList:
        #try:
        for _item in conf['modules'][name]:
            if _item.get('enabled') is not None:
                if _item['enabled'] == False:
                    print(f'{_item["topic"]} is not enabled, skip.')
                    continue
                if _item["data_type"] == "event":
                    mname = getModuleName(_item)
                    moduleDict[mname]=_item
        #except:
        #    pass
    return moduleDict

def getConf(fname):
    judge=os.path.isfile(fname)
    if judge:
        with open(fname, 'r') as _f:
            return json.load(_f)
    else:
        print("can't find file")
        return 0

def getRunList2Rec(rec_conf):
    recList=[]
    minRun=rec_conf["minRun"]
    maxRun=rec_conf["maxRun"]
    cmpPath=rec_conf["complete_local_path"]
    logPath=rec_conf["cxx_local_path"]
    try:
        complete=os.listdir(cmpPath)
    except:
        os.mkdir(cmpPath)
        complete=[]
    try:
        explog=os.listdir(logPath)
    except:
        os.mkdir(logPath)
        explog=[]
    for item in explog:
        if item[:3]=="RUN" and item not in complete:
            if int(item[-7:])>minRun and int(item[-7:])<maxRun:
                recList.append(item)
    return recList

