from Tasks import Task
from IO.Kafka import getDetectorData, getGlobalData

class KafkaGrabber(Task):
    def __init__(self, status, conf, backward=0):
        super().__init__(status)
        if type(conf) is not dict:
            raise Exception('Error: conf must be a dict')
        self.conf = conf
        self.previousPulseId = None
        self.dataType = self.conf['data_type']
        self.backward=backward

        self.consumer = KafkaConsumer(group_id=self.conf['group_id'],
                bootstrap_servers=self.conf['bootstrap_servers'],
                auto_offset_reset=self.conf['auto_offset_reset'],
                enable_auto_commit=self.conf['enable_auto_commit'],
                consumer_timeout_ms=self.conf['consumer_timeout_ms'])
        self.topicPartition =  TopicPartition(self.conf['topic'], 0)
        self.consumer.assign([topicPartition])
        self.consumer.seek_to_end()
        _current_offset = self.consumer.position(topicPartition)
        self.consumer.seek(topicPartition, int(_current_offset - self.backward))

    def getDataType(self):
        return self.dataType

    def run(self):
        for msg in self.consumer:
