/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.ids.irods;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.irods.jargon.core.connection.AuthScheme;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.JargonException;
import org.junit.Test;
import static org.junit.Assert.*;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.ExpectedException;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
public class IrodsUtilTest {

    @Rule
    public ExpectedException expectException = ExpectedException.none();

    private static final Properties properties = new Properties();

    public IrodsUtilTest() {
    }

    @BeforeClass
    public static void init() {
        String name = "META-INF/run.properties";
        URL url = IrodsUtilTest.class.getClassLoader().getResource(name);
        if (url == null) {
            Logger.getLogger(IrodsUtilTest.class.getName())
                    .log(Level.SEVERE, "Unable to locate resource {0}", name);
            return;
        }
        try {
            properties.load(new FileInputStream(url.getFile()));
        } catch (IOException ex) {
            Logger.getLogger(IrodsUtilTest.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
    }

    @Test
    public void testGetIrodsAccount() {
        try {
            IRODSAccount irodsAccount = IrodsUtil.getIrodsAccount(properties);
            assertEquals("rods", irodsAccount.getUserName());
            assertEquals("STANDARD", irodsAccount.getAuthenticationScheme().toString());
        } catch (JargonException ex) {
            Logger.getLogger(IrodsUtilTest.class.getName())
                    .log(Level.SEVERE, ex.getMessage());
        }
    }

    @Test
    public void testGetAuthScheme() {
        assertEquals(AuthScheme.STANDARD, IrodsUtil.getAuthScheme("sTanDard"));
        assertEquals(AuthScheme.PAM, IrodsUtil.getAuthScheme("pam"));

        expectException.expect(IllegalArgumentException.class);
        expectException.expectMessage("Not supported scheme");
        IrodsUtil.getAuthScheme("GIS");
        IrodsUtil.getAuthScheme("NotSupported");
    }

    @Test
    public void testTranslateToIrodsLocation() {
        String location = "/raw/BL02_RUN0001139_T0_FILE001_20180427033541.dat";
        String irodsLocationPrefix = properties.getProperty(Constants.IRODS_LOCATION_PREFIX, "").trim();
        String irodsLocationSuffix = properties.getProperty(Constants.IRODS_LOCATION_SUFFIX, "").trim();
        String expected = irodsLocationPrefix + location + irodsLocationSuffix;
        assertEquals(expected, IrodsUtil.translateToIrodsLocation(properties, location));
    }

}
