/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.ids.irods;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icatproject.ids.plugin.AbstractMainStorage;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.AuthenticationException;
import org.irods.jargon.core.exception.JargonException;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
public class IrodsMainStorage extends AbstractMainStorage {

    private Properties properties = new Properties();

    public IrodsMainStorage(Properties properties) {
        this.properties = properties;
    }

    @Override
    public InputStream get(String location, String createId, String modId) throws IOException {
        try {
            IRODSAccount irodsAccount = IrodsUtil.getIrodsAccount(properties);
            InputStream is = IrodsUtil.getInputStreamForIrodsPath(irodsAccount,
                    IrodsUtil.translateToIrodsLocation(properties, location));
            return is;
        } catch (AuthenticationException ex) {
            Logger.getLogger(IrodsMainStorage.class.getName())
                    .log(Level.SEVERE, ex.getMessage());
            throw new IOException(ex.getMessage(), ex);
        } catch (JargonException ex) {
            Logger.getLogger(IrodsMainStorage.class.getName())
                    .log(Level.SEVERE, ex.getMessage());
            throw new IOException(ex.getMessage(), ex);
        }
    }

}
