import json
from array import *
import sys

def tree(d, level=-1):
    if isinstance(d, dict):
        level+=1
        for k in d:
            _sep=''
            if not isinstance(k, dict):
                _sep=level*'- '
                print _sep+k
            tree(d[k], level)

def encode(d,parent=None):
    if isinstance(d, dict):
        for k, v in d.items():
            if not isinstance(v, dict):
                if k =='title':
                    d[k]='Diffraction Pattern'
                elif k =='bankname':
                    d[k]='Backward Bank'
                elif k =='type':
                    if parent == 'xaxis':
                        d[k]='I32_List_Bin'
                    elif parent == 'yaxis':
                        d[k]='F32_List_Bin'
                elif k =='unit':
                    if parent == 'xaxis':
                        d[k]='us'
                    elif parent == 'yaxis':
                        d[k]='A.U.'
                elif k =='long_name':
                    if parent == 'xaxis':
                        d[k]='TOF'
                    elif parent == 'yaxis':
                        d[k]='Intensity'
            else:
                parent=k
            encode(d[k],parent)

key_level = {'bankname':'','title':'','xaxis':{'type':'','long_name':'','unit':''},'yaxis':{'type':'','long_name':'','unit':''}}
tree(key_level)
encode(key_level)
print key_level

fout=open('key.json', 'w')
#key_level_str=JSONEncoder().encode(key_level)
#key_level_json=JSONDecoder().decode(key_level_str)
fout.write(json.dumps(key_level))#, fout, sort_keys=True, indent=4)
fout.close()
#print key_level_json

sys.exit(0)

