#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
Created on 2016.03.23

ServerSetting
'''

from conf.constants import *

from model.neonReceiver import *


class CSNSServerSetting(QtGui.QDialog):

    def __init__(self, parent):
        super(CSNSServerSetting, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QDialog):
        self.setWindowTitle('Data Streaming Server Setting')
        self.resize(200, 150)

        self.mainGrid = QtGui.QGridLayout(self)

        self.statusLabel = \
            QtGui.QLabel('<font color=red>X: Server not connected...</font>'
                         )

        self.ipLabel = QtGui.QLabel('<font color=red>HOST</font>')
        self.ipTextEdit = QtGui.QTextEdit('192.168.1.12')
        self.ipTextEdit.setMaximumHeight(30)
        self.ipTextEdit.setMinimumWidth(130)

        self.portLabel = QtGui.QLabel('<font color=red>PORT</font>')
        self.portTextEdit = QtGui.QTextEdit('9999')
        self.portTextEdit.setMaximumHeight(30)
        self.portTextEdit.setMinimumWidth(130)

        self.connectButton = QtGui.QPushButton('Connect')
        self.connectButton.clicked.connect(self.connectServer)

        self.cancelButton = QtGui.QPushButton('Cancel')
        self.cancelButton.clicked.connect(self.cancelServer)
        
	nrow = -1

        nrow = nrow + 1
        self.mainGrid.addWidget(
            self.statusLabel,
            nrow,
            0,
            1,
            2,
            QtCore.Qt.AlignCenter,
            )
        nrow = nrow + 1
        self.mainGrid.addWidget(
            self.ipLabel,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(
            self.ipTextEdit,
            nrow,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.mainGrid.addWidget(
            self.portLabel,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(
            self.portTextEdit,
            nrow,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.mainGrid.addWidget(
            self.cancelButton,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
	self.mainGrid.addWidget(
            self.connectButton,
            nrow,
            1,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )

	
    def getIP(self):
        try:
            return self.ipTextEdit.toPlainText()
        except:
            return None

    def getPort(self):
        try:
            return int(self.portTextEdit.toPlainText())
        except:
            return 0

    def setIP(self):
        self.parent.setIP(self.getIP())

    def setPort(self):
        self.parent.setPort(self.getPort())

    def connectServer(self):
        try:
            _r = isNeonConnector(self.getIP(), self.getPort())
            if _r:
                self.statusLabel.setText('<font color=red>O: Server connected...</font>'
                        )
                self.connectButton.setEnabled(False)
                print 'INFO: NEON server connected.'
            else:
                self.connectButton.setEnabled(True)
                print 'INFO: NEON server not connected.'
        except:
            self.connectButton.setEnabled(True)
            print 'INFO: NEON server not found.'
            return False

        return _r

    def cancelServer(self):
	self.close()
