from PyQt4 import QtGui, QtCore
import sys
import random
import time

class workerObject(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalStatus = QtCore.pyqtSignal(str)
    
    def __init__(self, parent=None, *args,**kwargs):
        super(self.__class__, self).__init__(parent)

        for kwarg in kwargs:
            if kwarg == 'neonServer':
                self.neonServer= kwargs[kwarg]
            elif kwarg == 'neonPath': 
                self.neonPath= kwargs[kwarg]
            elif kwarg == 'refreshTime': 
                self.refreshTime= kwargs[kwarg]
      
        try:
            type(self.refreshTime)
        except:
            self.refreshTime=0.3
 
        self.command=True
        self.mylist=["configure", "start", "stop", "pause", "abort"]

    def pause(self):
        self.command=False
    
    @QtCore.pyqtSlot()
    def process(self):
        while True:
            if not self.command: break
            try:
                i=random.randint(0,4)
                self.signalStatus.emit(self.mylist[i])
            except:
                continue

            time.sleep(self.refreshTime) 
        self.finished.emit()            

    def set(self, command):
        self.command=command
    
    def get(self):
        return self.command

class workerThread(QtCore.QThread):
    def __init__(self, parent):
        super(workerThread, self).__init__(parent)

    def __del__(self):
        self.wait()
