from conf import *
import thread
import threading
from model.globalClass import *
from model.diffractionSimulator import *

from matplotlib.figure import Figure
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg as FigureCanvas
from matplotlib.mlab import griddata
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D

class updateStreaming2D (threading.Thread):
    def __init__(self, threadID, can, ax, simulatorStreaming):
        threading.Thread.__init__(self)
        self.threadID = threadID
        self.simulatorStreaming=simulatorStreaming
        self.can=can
        self.ax=ax
        self.lines=self.ax.plot(self.simulatorStreaming.X, self.simulatorStreaming.Y)

    def run(self):
        while(self.simulatorStreaming.Connected):
            delay = 1 #random.randrange(1,10,1)/10.0
            time.sleep(delay)
            self.lines[0].set_xdata(self.simulatorStreaming.X)
            self.lines[0].set_ydata(self.simulatorStreaming.Y)
            #print self.ax.get_ylim()[1]
            self.ax.relim()
            self.ax.autoscale_view()
            self.can.draw()

class updateStreaming3D (threading.Thread):
    def __init__(self, threadID, can, ax, simulatorStreaming):
        threading.Thread.__init__(self)
        self.threadID = threadID
        self.simulatorStreaming=simulatorStreaming
        self.can=can
        self.ax=ax

    def run(self):
        _x=simulatorStreaming.Xaxis
        _y=simulatorStreaming.Yaxis

        while(self.simulatorStreaming.Connected):
            delay = 1 #random.randrange(1,10,1)/10.0
            time.sleep(delay)
            self.ax.pcolormesh(_x,_y, _z, cmap="Accent")
            self.can.draw()
