#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Histogram

'''

from conf.constants import *

from canvas import *
from model.readData import *
#from model.readImage import *
from presenter.updateStreaming import *
from model.neonReceiver import *


class CSNSHistogramPage(QtGui.QMainWindow):#QTabWidget):

    def __init__(self, parent):
        super(CSNSHistogramPage, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)
    
    def setupUi(self, Widget):#QTabWidget):
        #self.setTabPosition(QTabWidget.West)

	self.dock=QtGui.QDockWidget(self.tr(""), self)
	self.dock.setFeatures(QtGui.QDockWidget.DockWidgetFloatable)
	self.dock.setAllowedAreas(QtCore.Qt.TopDockWidgetArea)
	#self.verticalLayout = QtGui.QHBoxLayout(self)

        self.first = QtGui.QFrame(self.dock)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        # main  grid

        self.mainGrid = QtGui.QGridLayout(self.first)

        _xsize = 9
        _ysize = 0.8

        # Backward TOF/d

        self.BackwardComboBox = QtGui.QComboBox()
        self.BackwardComboBox.addItem('TOF')
        self.BackwardComboBox.addItem('d')
        self.BackwardComboBox.addItem('Q')
        self.BackwardComboBox.activated.connect(self.BackwardComboboxChoose)

        self.startBackward2DButton = QtGui.QPushButton('Start')
        self.startBackward2DButton.clicked.connect(self.startBackward2D)

        self.resumeBackward2DButton = QtGui.QPushButton('Pause')
        self.resumeBackward2DButton.setEnabled(False)
        self.resumeBackward2DButton.clicked.connect(self.resumeBackward2D)

        self.saveBackward2DButton = QtGui.QPushButton('Save')
        self.saveBackward2DButton.setEnabled(False)
        
        self.Backward2DCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # 90-Bank TOF/d

        self.MediumComboBox = QtGui.QComboBox()
        self.MediumComboBox.addItem('TOF')
        self.MediumComboBox.addItem('d')
        self.MediumComboBox.addItem('Q')
        self.MediumComboBox.activated.connect(self.MediumComboboxChoose)

        self.startMedium2DButton = QtGui.QPushButton('Start')
        self.startMedium2DButton.clicked.connect(self.startMedium2D)

        self.resumeMedium2DButton = QtGui.QPushButton('Pause')
        self.resumeMedium2DButton.setEnabled(False)
        self.resumeMedium2DButton.clicked.connect(self.resumeMedium2D)

        self.saveMedium2DButton = QtGui.QPushButton('Save')
        self.saveMedium2DButton.setEnabled(False)
        
        self.Medium2DCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Medium-Angle Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Small-angle bank TOF/d

        self.SmallComboBox = QtGui.QComboBox()
        self.SmallComboBox.addItem('TOF')
        self.SmallComboBox.addItem('d')
        self.SmallComboBox.addItem('Q')
        self.SmallComboBox.activated.connect(self.SmallComboboxChoose)

        self.startSmall2DButton = QtGui.QPushButton('Start')
        self.startSmall2DButton.clicked.connect(self.startSmall2D)

        self.resumeSmall2DButton = QtGui.QPushButton('Pause')
        self.resumeSmall2DButton.setEnabled(False)
        self.resumeSmall2DButton.clicked.connect(self.resumeSmall2D)

        self.saveSmall2DButton = QtGui.QPushButton('Save')
        self.saveSmall2DButton.setEnabled(False)
        
        self.Small2DCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Low-Angle Bank',
            'TOF /mics',
            'Neutron Counts',
            )
        
        _nline = 0
        self.mainGrid.addWidget(self.BackwardComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.startBackward2DButton, _nline, 1,
                                1, 1)
        self.mainGrid.addWidget(self.resumeBackward2DButton, _nline, 2,
                                1, 1)
        self.mainGrid.addWidget(self.saveBackward2DButton, _nline, 4,
                                1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.Backward2DCanvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.MediumComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.startMedium2DButton, _nline, 1, 1,
                                1)
        self.mainGrid.addWidget(self.resumeMedium2DButton, _nline, 2,
                                1, 1)
        self.mainGrid.addWidget(self.saveMedium2DButton, _nline, 4,
                                1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.Medium2DCanvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.SmallComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.startSmall2DButton, _nline, 1, 1,
                                1)
        self.mainGrid.addWidget(self.resumeSmall2DButton, _nline, 2, 1,
                                1)
        self.mainGrid.addWidget(self.saveSmall2DButton, _nline, 4, 1,
                                1)
        _nline += 1
        self.mainGrid.addWidget(
            self.Small2DCanvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1

        #self.verticalLayout.addWidget(self.scrollArea)
	#self.splitter = QtGui.QSplitter(QtCore.Qt.Horizontal)
	#self.splitter.addWidget(self.scrollArea)
	self.dock.setWidget(self.scrollArea)
        self.setCentralWidget(self.dock)
 
	self.can = [
            self.Backward2DCanvas,
            self.Medium2DCanvas,
            self.Small2DCanvas,
            ]

        self.neonID = [
            '/BL01/BANK01/PATTERN',
            '/BL01/BANK03/PATTERN',
            '/BL01/BANK05/PATTERN',
            ]

        Backward2DStreaming = None
        Medium2DStreaming = None
        Small2DStreaming = None
        self.streaming = [
            Backward2DStreaming,
            Medium2DStreaming,
            Small2DStreaming,
            ]
        for i in range(3):
            self.streaming[i] = CSNSGlobal()

        Backward2DstreamingThread = None
        Medium2DstreamingThread = None
        Small2DstreamingThread = None
        self.streamingThread = [
            Backward2DstreamingThread,
            Medium2DstreamingThread,
            Small2DstreamingThread,
            ]

        Backward2DplotThread = None
        Medium2DplotThread = None
        Small2DplotThread = None
        self.plotThread = [
            Backward2DplotThread,
            Medium2DplotThread,
            Small2DplotThread,
            ]

        self.plotColor = [
            'r',
            'g',
            'b',
            ]

        self.plotScale = [
            40000,
            30000,
            20000,
            ]

        self.sourceID=-1

    def BackwardComboboxChoose(self):
        index = self.BackwardComboBox.currentIndex()
        if index == 0:
            _scale = 40000
        elif index == 1:
            _scale = 1

        try:
            self.plotThread[0].setUnit(_scale)
        except:
            pass

    def MediumComboboxChoose(self):
        index = self.MediumComboBox.currentIndex()
        if index == 0:
            _scale = 30000
        elif index == 1:
            _scale = 1

        try:
            self.plotThread[1].setUnit(_scale)
        except:
            pass

    def SmallComboboxChoose(self):
        index = self.SmallComboBox.currentIndex()
        if index == 0:
            _scale = 20000
        elif index == 1:
            _scale = 1

        try:
            self.plotThread[2].setUnit(_scale)
        except:
            pass
    def startDiffractionSimulator(self):
        self.setSource(2)

    def createStreamingThread(self, sourceID, bankID):
        global CSNSThreadID
        CSNSThreadID += 1

        if sourceID == 2:
            self.streamingThread[bankID] = diffractionSimulator(
                CSNSThreadID,
                3,
                './dat/gppd.dat',
                './dat/monitor.dat',
                1E6,
                1.0,
                self.streaming[bankID],
                )
        elif sourceID == 0:
            self.streamingThread[bankID] = neonReceiver(
                CSNSThreadID,
                self.getIP(),
                self.getPort(),
                self.neonID[bankID],
                1.0,
                self.streaming[bankID],
                )

        self.streamingThread[bankID].setDaemon(True)

    def createPlotThread(self, bankID):
        global CSNSThreadID
        CSNSThreadID += 1

        self.plotThread[bankID] = updateStreaming2D(
            CSNSThreadID,
            self.can[bankID],
            self.can[bankID].ax,
            self.plotScale[bankID],
            self.plotColor[bankID],
            self.streaming[bankID],
            )

        self.plotThread[bankID].setDaemon(True)

    def startBackward2D(self):
        _sourceID=self.getSource()
        if not(_sourceID ==0 or _sourceID ==2):
            print "ERROR: The streaming server not started."            
            return

        _bankID = 0
        if self.startBackward2DButton.text() == 'Start':
            self.createStreamingThread(self.getSource(), _bankID)
            self.createPlotThread(_bankID)

            self.streamingThread[_bankID].start()
            self.plotThread[_bankID].start()

            self.startBackward2DButton.setText('Stop')
            self.resumeBackward2DButton.setText('Pause')
            self.resumeBackward2DButton.setEnabled(True)
        elif self.startBackward2DButton.text() == 'Stop':

            self.plotThread[_bankID].stop()
            del self.plotThread[_bankID]
            self.streamingThread[_bankID].stop()
            del self.streamingThread[_bankID]

            self.startBackward2DButton.setText('Start')
            self.resumeBackward2DButton.setText('Resume')
            self.resumeBackward2DButton.setEnabled(False)

    def resumeBackward2D(self):
        _bankID = 0
        if self.resumeBackward2DButton.text() == 'Resume':
            self.plotThread[_bankID].resume()
            self.resumeBackward2DButton.setText('Pause')
        elif self.resumeBackward2DButton.text() == 'Pause':

            self.plotThread[_bankID].pause()
            self.resumeBackward2DButton.setText('Resume')

    def startMedium2D(self):
        _sourceID=self.getSource()
        if not(_sourceID ==0 or _sourceID ==2):
            print "ERROR: The streaming server not started."
            return

        _bankID = 1
        if self.startMedium2DButton.text() == 'Start':
            self.createStreamingThread(self.getSource(), _bankID)
            self.createPlotThread(_bankID)

            self.streamingThread[_bankID].start()
            self.plotThread[_bankID].start()

            self.startMedium2DButton.setText('Stop')
            self.resumeMedium2DButton.setText('Pause')
            self.resumeMedium2DButton.setEnabled(True)
        elif self.startMedium2DButton.text() == 'Stop':

            self.plotThread[_bankID].stop()
            del self.plotThread[_bankID]
            self.streamingThread[_bankID].stop()
            del self.streamingThread[_bankID]

            self.startMedium2DButton.setText('Start')
            self.resumeMedium2DButton.setText('Resume')
            self.resumeMedium2DButton.setEnabled(False)

    def resumeMedium2D(self):
        _bankID = 1
        if self.resumeMedium2DButton.text() == 'Resume':
            self.plotThread[_bankID].resume()
            self.resumeMedium2DButton.setText('Pause')
        elif self.resumeMedium2DButton.text() == 'Pause':

            self.plotThread[_bankID].pause()
            self.resumeMedium2DButton.setText('Resume')

    def startSmall2D(self):
        _sourceID=self.getSource()
        if not(_sourceID ==0 or _sourceID ==2):
            print "ERROR: The streaming server not started."
            return

        _bankID = 2
        if self.startSmall2DButton.text() == 'Start':
            self.createStreamingThread(self.getSource(), _bankID)
            self.createPlotThread(_bankID)

            self.streamingThread[_bankID].start()
            self.plotThread[_bankID].start()

            self.startSmall2DButton.setText('Stop')
            self.resumeSmall2DButton.setText('Pause')
            self.resumeSmall2DButton.setEnabled(True)
        elif self.startSmall2DButton.text() == 'Stop':

            self.plotThread[_bankID].stop()
            del self.plotThread[_bankID]
            self.streamingThread[_bankID].stop()
            del self.streamingThread[_bankID]

            self.startSmall2DButton.setText('Start')
            self.resumeSmall2DButton.setText('Resume')
            self.resumeSmall2DButton.setEnabled(False)

    def resumeSmall2D(self):
        _bankID = 2
        if self.resumeSmall2DButton.text() == 'Resume':
            self.plotThread[_bankID].resume()
            self.resumeSmall2DButton.setText('Pause')
        elif self.resumeSmall2DButton.text() == 'Pause':

            self.plotThread[_bankID].pause()
            self.resumeSmall2DButton.setText('Resume')

    def isStreamingThread(self, bankID):
        try:
            self.streamingThread(bankID)
            return True
        except:
            return False

    def isPlotThread(self, bankID):
        try:
            self.plotThread(bankID)
            return True
        except:
            return False

    def getIP(self):
        return self.parent.getIP()

    def getPort(self):
        return self.parent.getPort()

    def getSource(self):
        return self.sourceID

    def setSource(self, id):
        self.sourceID=id
